/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.builder.saxon;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.XPathException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.builder.saxon.ResultFormat;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.BytesSource;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.util.ObjectHelper;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XQueryBuilder<E extends Exchange>
implements Expression<E>,
Predicate<E> {
    private Configuration configuration;
    private XQueryExpression expression;
    private StaticQueryContext staticQueryContext;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private XmlConverter converter = new XmlConverter();
    private ResultFormat resultsFormat = ResultFormat.DOM;
    private Properties properties = new Properties();

    public String toString() {
        return "XQuery[" + this.expression + "]";
    }

    public Object evaluate(E exchange) {
        try {
            switch (this.resultsFormat) {
                case Bytes: {
                    return this.evaluateAsBytes(exchange);
                }
                case BytesSource: {
                    return this.evaluateAsBytesSource(exchange);
                }
                case DOM: {
                    return this.evaluateAsDOM(exchange);
                }
                case List: {
                    return this.evaluateAsList(exchange);
                }
                case StringSource: {
                    return this.evaluateAsStringSource(exchange);
                }
            }
            return this.evaluateAsString(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    public List evaluateAsList(E exchange) throws Exception {
        return this.getExpression().evaluate(this.createDynamicContext(exchange));
    }

    public Object evaluateAsStringSource(E exchange) throws Exception {
        String text = this.evaluateAsString(exchange);
        return new StringSource(text);
    }

    public Object evaluateAsBytesSource(E exchange) throws Exception {
        byte[] bytes = this.evaluateAsBytes(exchange);
        return new BytesSource(bytes);
    }

    public Node evaluateAsDOM(E exchange) throws Exception {
        DOMResult result = new DOMResult();
        this.getExpression().pull(this.createDynamicContext(exchange), (Result)result, this.properties);
        return result.getNode();
    }

    public byte[] evaluateAsBytes(E exchange) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        this.getExpression().pull(this.createDynamicContext(exchange), (Result)result, this.properties);
        byte[] bytes = buffer.toByteArray();
        return bytes;
    }

    public String evaluateAsString(E exchange) throws Exception {
        StringWriter buffer = new StringWriter();
        StreamResult result = new StreamResult(buffer);
        this.getExpression().pull(this.createDynamicContext(exchange), (Result)result, this.properties);
        String text = buffer.toString();
        return text;
    }

    public boolean matches(E exchange) {
        try {
            List list = this.evaluateAsList(exchange);
            return this.matches(exchange, list);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    public void assertMatches(String text, E exchange) throws AssertionError {
        try {
            List list = this.evaluateAsList(exchange);
            if (!this.matches(exchange, list)) {
                throw new AssertionError((Object)(this + " failed on " + exchange + " as evaluated: " + list));
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(final String queryText) {
        return new XQueryBuilder<E>(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException {
                return staticQueryContext.compileQuery(queryText);
            }
        };
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(final Reader reader) {
        return new XQueryBuilder<E>(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException, IOException {
                return staticQueryContext.compileQuery(reader);
            }
        };
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(final InputStream in, final String characterSet) {
        return new XQueryBuilder<E>(){

            @Override
            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException, IOException {
                return staticQueryContext.compileQuery(in, characterSet);
            }
        };
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(File file, String characterSet) throws FileNotFoundException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((File)file), characterSet);
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(URL url, String characterSet) throws IOException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((URL)url), characterSet);
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(File file) throws FileNotFoundException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((File)file), ObjectHelper.getDefaultCharacterSet());
    }

    public static <E extends Exchange> XQueryBuilder<E> xquery(URL url) throws IOException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((URL)url), ObjectHelper.getDefaultCharacterSet());
    }

    public XQueryBuilder<E> asBytes() {
        this.setResultsFormat(ResultFormat.Bytes);
        return this;
    }

    public XQueryBuilder<E> asBytesSource() {
        this.setResultsFormat(ResultFormat.BytesSource);
        return this;
    }

    public XQueryBuilder<E> asDOM() {
        this.setResultsFormat(ResultFormat.DOM);
        return this;
    }

    public XQueryBuilder<E> asDOMSource() {
        this.setResultsFormat(ResultFormat.DOMSource);
        return this;
    }

    public XQueryBuilder<E> asList() {
        this.setResultsFormat(ResultFormat.List);
        return this;
    }

    public XQueryBuilder<E> asString() {
        this.setResultsFormat(ResultFormat.String);
        return this;
    }

    public XQueryBuilder<E> asStringSource() {
        this.setResultsFormat(ResultFormat.StringSource);
        return this;
    }

    public XQueryBuilder<E> parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public XQueryExpression getExpression() throws IOException, XPathException {
        if (this.expression == null) {
            this.expression = this.createQueryExpression(this.getStaticQueryContext());
            this.clearBuilderReferences();
        }
        return this.expression;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            this.configuration.setHostLanguage(51);
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public StaticQueryContext getStaticQueryContext() {
        if (this.staticQueryContext == null) {
            this.staticQueryContext = new StaticQueryContext(this.getConfiguration());
        }
        return this.staticQueryContext;
    }

    public void setStaticQueryContext(StaticQueryContext staticQueryContext) {
        this.staticQueryContext = staticQueryContext;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ResultFormat getResultsFormat() {
        return this.resultsFormat;
    }

    public void setResultsFormat(ResultFormat resultsFormat) {
        this.resultsFormat = resultsFormat;
    }

    protected abstract XQueryExpression createQueryExpression(StaticQueryContext var1) throws XPathException, IOException;

    protected DynamicQueryContext createDynamicContext(E exchange) throws Exception {
        Configuration config = this.getConfiguration();
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(config);
        Source source = (Source)exchange.getIn().getBody(Source.class);
        if (source == null) {
            source = this.converter.toSource(this.converter.createDocument());
        }
        DocumentInfo doc = this.getStaticQueryContext().buildDocument(source);
        dynamicQueryContext.setContextItem((Item)doc);
        this.configureQuery(dynamicQueryContext, (Exchange)exchange);
        return dynamicQueryContext;
    }

    protected void configureQuery(DynamicQueryContext dynamicQueryContext, Exchange exchange) throws Exception {
        this.addParameters(dynamicQueryContext, exchange.getProperties());
        this.addParameters(dynamicQueryContext, exchange.getIn().getHeaders());
        this.addParameters(dynamicQueryContext, this.getParameters());
        dynamicQueryContext.setParameter("exchange", (Object)exchange);
        dynamicQueryContext.setParameter("in", (Object)exchange.getIn());
        dynamicQueryContext.setParameter("out", (Object)exchange.getOut());
    }

    protected void addParameters(DynamicQueryContext dynamicQueryContext, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            dynamicQueryContext.setParameter(entry.getKey(), entry.getValue());
        }
    }

    protected void clearBuilderReferences() {
        this.staticQueryContext = null;
        this.configuration = null;
    }

    protected boolean matches(E exchange, List results) {
        return ObjectHelper.matches((List)results);
    }
}

