/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.query.DynamicQueryContext;
import net.sf.saxon.query.StaticQueryContext;
import net.sf.saxon.query.XQueryExpression;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeExpressionException;
import org.apache.camel.component.xquery.ResultFormat;
import org.apache.camel.converter.IOConverter;
import org.apache.camel.converter.jaxp.BytesSource;
import org.apache.camel.converter.jaxp.StringSource;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.spi.NamespaceAware;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XQueryBuilder
implements Expression<Exchange>,
Predicate<Exchange>,
NamespaceAware,
Processor {
    private static final transient Log LOG = LogFactory.getLog(XQueryBuilder.class);
    private Configuration configuration;
    private XQueryExpression expression;
    private StaticQueryContext staticQueryContext;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private Map<String, String> namespacePrefixes = new HashMap<String, String>();
    private XmlConverter converter = new XmlConverter();
    private ResultFormat resultsFormat = ResultFormat.DOM;
    private Properties properties = new Properties();
    private Class resultType;

    public String toString() {
        return "XQuery[" + this.expression + "]";
    }

    public void process(Exchange exchange) throws Exception {
        Object body = this.evaluate(exchange);
        exchange.getOut(true).setBody(body);
    }

    public Object evaluate(Exchange exchange) {
        try {
            if (this.resultType != null) {
                if (this.resultType.equals(String.class)) {
                    return this.evaluateAsString(exchange);
                }
                if (this.resultType.isAssignableFrom(Collection.class)) {
                    return this.evaluateAsList(exchange);
                }
                if (this.resultType.isAssignableFrom(Node.class)) {
                    return this.evaluateAsDOM(exchange);
                }
            }
            switch (this.resultsFormat) {
                case Bytes: {
                    return this.evaluateAsBytes(exchange);
                }
                case BytesSource: {
                    return this.evaluateAsBytesSource(exchange);
                }
                case DOM: {
                    return this.evaluateAsDOM(exchange);
                }
                case List: {
                    return this.evaluateAsList(exchange);
                }
                case StringSource: {
                    return this.evaluateAsStringSource(exchange);
                }
            }
            return this.evaluateAsString(exchange);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespacePrefixes.putAll(namespaces);
    }

    public List evaluateAsList(Exchange exchange) throws Exception {
        return this.getExpression().evaluate(this.createDynamicContext(exchange));
    }

    public Object evaluateAsStringSource(Exchange exchange) throws Exception {
        String text = this.evaluateAsString(exchange);
        return new StringSource(text);
    }

    public Object evaluateAsBytesSource(Exchange exchange) throws Exception {
        byte[] bytes = this.evaluateAsBytes(exchange);
        return new BytesSource(bytes);
    }

    public Node evaluateAsDOM(Exchange exchange) throws Exception {
        DOMResult result = new DOMResult();
        DynamicQueryContext context = this.createDynamicContext(exchange);
        XQueryExpression expression = this.getExpression();
        expression.pull(context, (Result)result, this.properties);
        return result.getNode();
    }

    public byte[] evaluateAsBytes(Exchange exchange) throws Exception {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(buffer);
        this.getExpression().pull(this.createDynamicContext(exchange), (Result)result, this.properties);
        byte[] bytes = buffer.toByteArray();
        return bytes;
    }

    public String evaluateAsString(Exchange exchange) throws Exception {
        StringWriter buffer = new StringWriter();
        SequenceIterator iter = this.getExpression().iterator(this.createDynamicContext(exchange));
        Item item = iter.next();
        while (item != null) {
            buffer.append(item.getStringValueCS());
            item = iter.next();
        }
        return buffer.toString();
    }

    public boolean matches(Exchange exchange) {
        try {
            List list = this.evaluateAsList(exchange);
            return this.matches(exchange, list);
        }
        catch (Exception e) {
            throw new RuntimeExpressionException((Throwable)e);
        }
    }

    public void assertMatches(String text, Exchange exchange) throws AssertionError {
        try {
            List list = this.evaluateAsList(exchange);
            if (!this.matches(exchange, list)) {
                throw new AssertionError((Object)(this + " failed on " + exchange + " as evaluated: " + list));
            }
        }
        catch (Exception e) {
            throw new AssertionError((Object)e);
        }
    }

    public static XQueryBuilder xquery(final String queryText) {
        return new XQueryBuilder(){

            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException {
                return staticQueryContext.compileQuery(queryText);
            }
        };
    }

    public static XQueryBuilder xquery(final Reader reader) {
        return new XQueryBuilder(){

            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException, IOException {
                return staticQueryContext.compileQuery(reader);
            }
        };
    }

    public static XQueryBuilder xquery(final InputStream in, final String characterSet) {
        return new XQueryBuilder(){

            protected XQueryExpression createQueryExpression(StaticQueryContext staticQueryContext) throws XPathException, IOException {
                return staticQueryContext.compileQuery(in, characterSet);
            }
        };
    }

    public static XQueryBuilder xquery(File file, String characterSet) throws FileNotFoundException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((File)file), characterSet);
    }

    public static XQueryBuilder xquery(URL url, String characterSet) throws IOException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((URL)url), characterSet);
    }

    public static XQueryBuilder xquery(File file) throws FileNotFoundException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((File)file), ObjectHelper.getDefaultCharacterSet());
    }

    public static XQueryBuilder xquery(URL url) throws IOException {
        return XQueryBuilder.xquery(IOConverter.toInputStream((URL)url), ObjectHelper.getDefaultCharacterSet());
    }

    public XQueryBuilder parameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public XQueryBuilder namespace(String prefix, String uri) {
        this.namespacePrefixes.put(prefix, uri);
        return this;
    }

    public XQueryBuilder resultType(Class resultType) {
        this.setResultType(resultType);
        return this;
    }

    public XQueryBuilder asBytes() {
        this.setResultsFormat(ResultFormat.Bytes);
        return this;
    }

    public XQueryBuilder asBytesSource() {
        this.setResultsFormat(ResultFormat.BytesSource);
        return this;
    }

    public XQueryBuilder asDOM() {
        this.setResultsFormat(ResultFormat.DOM);
        return this;
    }

    public XQueryBuilder asDOMSource() {
        this.setResultsFormat(ResultFormat.DOMSource);
        return this;
    }

    public XQueryBuilder asList() {
        this.setResultsFormat(ResultFormat.List);
        return this;
    }

    public XQueryBuilder asString() {
        this.setResultsFormat(ResultFormat.String);
        return this;
    }

    public XQueryBuilder asStringSource() {
        this.setResultsFormat(ResultFormat.StringSource);
        return this;
    }

    public XQueryExpression getExpression() throws IOException, XPathException {
        if (this.expression == null) {
            this.expression = this.createQueryExpression(this.getStaticQueryContext());
            this.clearBuilderReferences();
        }
        return this.expression;
    }

    public Configuration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = new Configuration();
            this.configuration.setHostLanguage(51);
        }
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public StaticQueryContext getStaticQueryContext() throws StaticError {
        if (this.staticQueryContext == null) {
            this.staticQueryContext = new StaticQueryContext(this.getConfiguration());
            Set<Map.Entry<String, String>> entries = this.namespacePrefixes.entrySet();
            for (Map.Entry<String, String> entry : entries) {
                String prefix = entry.getKey();
                String uri = entry.getValue();
                this.staticQueryContext.declarePassiveNamespace(prefix, uri, false);
                this.staticQueryContext.setInheritNamespaces(true);
            }
        }
        return this.staticQueryContext;
    }

    public void setStaticQueryContext(StaticQueryContext staticQueryContext) {
        this.staticQueryContext = staticQueryContext;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, Object> parameters) {
        this.parameters = parameters;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public ResultFormat getResultsFormat() {
        return this.resultsFormat;
    }

    public void setResultsFormat(ResultFormat resultsFormat) {
        this.resultsFormat = resultsFormat;
    }

    public Class getResultType() {
        return this.resultType;
    }

    public void setResultType(Class resultType) {
        this.resultType = resultType;
    }

    protected abstract XQueryExpression createQueryExpression(StaticQueryContext var1) throws XPathException, IOException;

    protected DynamicQueryContext createDynamicContext(Exchange exchange) throws Exception {
        Configuration config = this.getConfiguration();
        DynamicQueryContext dynamicQueryContext = new DynamicQueryContext(config);
        Message in = exchange.getIn();
        Item item = (Item)in.getBody(Item.class);
        Source source = null;
        if (item != null) {
            dynamicQueryContext.setContextItem(item);
        } else {
            source = (Source)in.getBody(Source.class);
            if (source == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("No body available on exchange so using an empty document: " + exchange));
                }
                source = this.converter.toSource(this.converter.createDocument());
            }
            DocumentInfo doc = this.getStaticQueryContext().buildDocument(source);
            dynamicQueryContext.setContextItem((Item)doc);
        }
        this.configureQuery(dynamicQueryContext, exchange);
        return dynamicQueryContext;
    }

    protected void configureQuery(DynamicQueryContext dynamicQueryContext, Exchange exchange) throws Exception {
        this.addParameters(dynamicQueryContext, exchange.getProperties());
        this.addParameters(dynamicQueryContext, exchange.getIn().getHeaders());
        this.addParameters(dynamicQueryContext, this.getParameters());
        dynamicQueryContext.setParameter("exchange", (Object)exchange);
        dynamicQueryContext.setParameter("in", (Object)exchange.getIn());
        dynamicQueryContext.setParameter("out", (Object)exchange.getOut());
    }

    protected void addParameters(DynamicQueryContext dynamicQueryContext, Map<String, Object> map) {
        Set<Map.Entry<String, Object>> propertyEntries = map.entrySet();
        for (Map.Entry<String, Object> entry : propertyEntries) {
            dynamicQueryContext.setParameter(entry.getKey(), entry.getValue());
        }
    }

    protected void clearBuilderReferences() {
        this.staticQueryContext = null;
        this.configuration = null;
    }

    protected boolean matches(Exchange exchange, List results) {
        return ObjectHelper.matches((List)results);
    }
}

