/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.lang.annotation.Annotation;
import net.sf.saxon.functions.Collection;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.component.bean.DefaultAnnotationExpressionFactory;
import org.apache.camel.component.xquery.ResultFormat;
import org.apache.camel.component.xquery.XQuery;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.language.LanguageAnnotation;
import org.apache.camel.language.NamespacePrefix;
import org.w3c.dom.Node;

public class XQueryAnnotationExpressionFactory
extends DefaultAnnotationExpressionFactory {
    public Expression createExpression(CamelContext camelContext, Annotation annotation, LanguageAnnotation languageAnnotation, Class expressionReturnType) {
        String xQuery = this.getExpressionFromAnnotation(annotation);
        XQueryBuilder builder = XQueryBuilder.xquery(xQuery);
        if (annotation instanceof XQuery) {
            XQuery xQueryAnnotation = (XQuery)annotation;
            builder.setStripsAllWhiteSpace(xQueryAnnotation.stripsAllWhiteSpace());
            NamespacePrefix[] namespaces = xQueryAnnotation.namespaces();
            if (namespaces != null) {
                for (NamespacePrefix namespacePrefix : namespaces) {
                    builder = builder.namespace(namespacePrefix.prefix(), namespacePrefix.uri());
                }
            }
        }
        if (expressionReturnType.isAssignableFrom(String.class)) {
            builder.setResultsFormat(ResultFormat.String);
        } else if (expressionReturnType.isAssignableFrom(Collection.class)) {
            builder.setResultsFormat(ResultFormat.List);
        } else if (expressionReturnType.isAssignableFrom(Node.class)) {
            builder.setResultsFormat(ResultFormat.DOM);
        } else if (expressionReturnType.isAssignableFrom(byte[].class)) {
            builder.setResultsFormat(ResultFormat.Bytes);
        }
        return builder;
    }
}

