/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.net.URL;
import java.util.Map;
import net.sf.saxon.query.ModuleURIResolver;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.component.xquery.XQueryModuleURIResolver;
import org.apache.camel.impl.ProcessorEndpoint;
import org.springframework.core.io.Resource;

public class XQueryComponent
extends ResourceBasedComponent {
    private ModuleURIResolver moduleURIResolver = new XQueryModuleURIResolver(this);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        Resource resource = this.resolveMandatoryResource(remaining);
        this.log.debug("{} using schema resource: {}", (Object)this, (Object)resource);
        XQueryBuilder xslt = XQueryBuilder.xquery(resource.getURL());
        xslt.setModuleURIResolver(this.getModuleURIResolver());
        this.configureXslt(xslt, uri, remaining, parameters);
        return new ProcessorEndpoint(uri, (Component)this, (Processor)xslt);
    }

    protected void configureXslt(XQueryBuilder xQueryBuilder, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(xQueryBuilder, parameters);
    }

    public URL resolveModuleResource(String uri) throws Exception {
        return this.resolveMandatoryResource(uri).getURL();
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }
}

