/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xquery;

import java.net.URL;
import java.util.Map;
import net.sf.saxon.query.ModuleURIResolver;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.xquery.XQueryBuilder;
import org.apache.camel.component.xquery.XQueryModuleURIResolver;
import org.apache.camel.impl.DefaultComponent;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.util.ResourceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XQueryComponent
extends DefaultComponent {
    private static final transient Logger LOG = LoggerFactory.getLogger(XQueryComponent.class);
    private ModuleURIResolver moduleURIResolver = new XQueryModuleURIResolver(this);

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String resourceUri = remaining;
        URL url = this.resolveModuleResource(resourceUri);
        LOG.debug("{} using schema resource: {}", (Object)this, (Object)resourceUri);
        XQueryBuilder xslt = XQueryBuilder.xquery(url);
        xslt.setModuleURIResolver(this.getModuleURIResolver());
        this.configureXslt(xslt, uri, remaining, parameters);
        return new ProcessorEndpoint(uri, (Component)this, (Processor)xslt);
    }

    protected void configureXslt(XQueryBuilder xQueryBuilder, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(xQueryBuilder, parameters);
    }

    public URL resolveModuleResource(String uri) throws Exception {
        return ResourceHelper.resolveMandatoryResourceAsUrl((ClassResolver)this.getCamelContext().getClassResolver(), (String)uri);
    }

    public ModuleURIResolver getModuleURIResolver() {
        return this.moduleURIResolver;
    }

    public void setModuleURIResolver(ModuleURIResolver moduleURIResolver) {
        this.moduleURIResolver = moduleURIResolver;
    }
}

