/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.servlet.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.Lifecycle;

public class OsgiServletRegisterer
implements Lifecycle,
InitializingBean {
    private String alias;
    private HttpServlet servlet;
    private HttpService httpService;
    private HttpContext httpContext;
    private boolean alreadyRegistered;

    public void setHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setServlet(HttpServlet servlet) {
        this.servlet = servlet;
    }

    public void setHttpContext(HttpContext httpContext) {
        this.httpContext = httpContext;
    }

    public void afterPropertiesSet() throws Exception {
        HttpContext actualHttpContext = this.httpContext == null ? this.httpService.createDefaultHttpContext() : this.httpContext;
        Hashtable<String, String> initParams = new Hashtable<String, String>();
        ((Dictionary)initParams).put("matchOnUriPrefix", "true");
        try {
            String servletName = this.servlet.getServletName();
            ((Dictionary)initParams).put("servlet-name", servletName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.httpService.registerServlet(this.alias, (Servlet)this.servlet, initParams, actualHttpContext);
        this.alreadyRegistered = true;
    }

    public void start() {
    }

    public void stop() {
        if (this.alreadyRegistered) {
            this.httpService.unregister(this.alias);
            this.alreadyRegistered = false;
        }
    }

    public boolean isRunning() {
        return this.alreadyRegistered;
    }
}

