/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.concurrent.ExecutorService;
import javax.jms.Connection;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.apache.camel.CamelException;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.consumer.AbstractMessageHandler;
import org.apache.camel.component.sjms.consumer.InOnlyMessageHandler;
import org.apache.camel.component.sjms.consumer.InOutMessageHandler;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms.jms.ObjectPool;
import org.apache.camel.component.sjms.taskmanager.TimedTaskManager;
import org.apache.camel.component.sjms.tx.BatchTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.SessionBatchTransactionSynchronization;
import org.apache.camel.component.sjms.tx.SessionTransactionSynchronization;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spi.Synchronization;

public class SjmsConsumer
extends DefaultConsumer {
    protected MessageConsumerPool consumers;
    private final ExecutorService executor;

    public SjmsConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.executor = endpoint.getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "SjmsConsumer");
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.consumers = new MessageConsumerPool();
        this.consumers.fillPool();
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.consumers != null) {
            this.consumers.drainPool();
            this.consumers = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageConsumerResources createConsumer() throws Exception {
        MessageConsumerResources answer = null;
        Connection conn = null;
        try {
            conn = this.getConnectionResource().borrowConnection();
            Session session = null;
            MessageConsumer messageConsumer = null;
            session = this.isTransacted() ? conn.createSession(true, 0) : conn.createSession(false, 1);
            messageConsumer = JmsObjectFactory.createMessageConsumer(session, this.getDestinationName(), this.getMessageSelector(), this.isTopic(), this.getDurableSubscriptionId());
            MessageListener handler = this.createMessageHandler(session);
            messageConsumer.setMessageListener(handler);
            if (session == null) {
                throw new CamelException("Message Consumer Creation Exception: Session is NULL");
            }
            if (messageConsumer == null) {
                throw new CamelException("Message Consumer Creation Exception: MessageConsumer is NULL");
            }
            answer = new MessageConsumerResources(session, messageConsumer);
        }
        catch (Exception e) {
            this.log.error("Unable to create the MessageConsumer: " + e.getLocalizedMessage());
        }
        finally {
            if (conn != null) {
                this.getConnectionResource().returnConnection(conn);
            }
        }
        return answer;
    }

    protected MessageListener createMessageHandler(Session session) {
        Object synchronization;
        TransactionCommitStrategy commitStrategy = null;
        commitStrategy = this.getTransactionCommitStrategy() != null ? this.getTransactionCommitStrategy() : (this.getTransactionBatchCount() > 0 ? new BatchTransactionCommitStrategy(this.getTransactionBatchCount()) : new DefaultTransactionCommitStrategy());
        if (commitStrategy instanceof BatchTransactionCommitStrategy) {
            TimedTaskManager timedTaskManager = this.getEndpoint().getComponent().getTimedTaskManager();
            synchronization = new SessionBatchTransactionSynchronization(timedTaskManager, session, commitStrategy, this.getTransactionBatchTimeout());
        } else {
            synchronization = new SessionTransactionSynchronization(session, commitStrategy);
        }
        AbstractMessageHandler messageHandler = this.getEndpoint().getExchangePattern().equals((Object)ExchangePattern.InOnly) ? (this.isTransacted() ? new InOnlyMessageHandler((Endpoint)this.getEndpoint(), this.executor, (Synchronization)synchronization) : new InOnlyMessageHandler((Endpoint)this.getEndpoint(), this.executor)) : (this.isTransacted() ? new InOutMessageHandler((Endpoint)this.getEndpoint(), this.executor, (Synchronization)synchronization) : new InOutMessageHandler((Endpoint)this.getEndpoint(), this.executor));
        messageHandler.setSession(session);
        messageHandler.setProcessor(this.getAsyncProcessor());
        messageHandler.setSynchronous(this.isSynchronous());
        messageHandler.setTransacted(this.isTransacted());
        messageHandler.setTopic(this.isTopic());
        return messageHandler;
    }

    protected ConnectionResource getConnectionResource() {
        return this.getEndpoint().getConnectionResource();
    }

    public int getAcknowledgementMode() {
        return this.getEndpoint().getAcknowledgementMode().intValue();
    }

    public boolean isTransacted() {
        return this.getEndpoint().isTransacted();
    }

    public boolean isSynchronous() {
        return this.getEndpoint().isSynchronous();
    }

    public String getDestinationName() {
        return this.getEndpoint().getDestinationName();
    }

    public int getConsumerCount() {
        return this.getEndpoint().getConsumerCount();
    }

    public boolean isTopic() {
        return this.getEndpoint().isTopic();
    }

    public String getMessageSelector() {
        return this.getEndpoint().getMessageSelector();
    }

    public String getDurableSubscriptionId() {
        return this.getEndpoint().getDurableSubscriptionId();
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.getEndpoint().getTransactionCommitStrategy();
    }

    public int getTransactionBatchCount() {
        return this.getEndpoint().getTransactionBatchCount();
    }

    public long getTransactionBatchTimeout() {
        return this.getEndpoint().getTransactionBatchTimeout();
    }

    protected class MessageConsumerResources {
        private final Session session;
        private final MessageConsumer messageConsumer;

        public MessageConsumerResources(MessageConsumer messageConsumer) {
            this.session = null;
            this.messageConsumer = messageConsumer;
        }

        public MessageConsumerResources(Session session, MessageConsumer messageConsumer) {
            this.session = session;
            this.messageConsumer = messageConsumer;
        }

        public Session getSession() {
            return this.session;
        }

        public MessageConsumer getMessageConsumer() {
            return this.messageConsumer;
        }
    }

    protected class MessageConsumerPool
    extends ObjectPool<MessageConsumerResources> {
        public MessageConsumerPool() {
            super(SjmsConsumer.this.getConsumerCount());
        }

        @Override
        protected MessageConsumerResources createObject() throws Exception {
            MessageConsumerResources model = SjmsConsumer.this.createConsumer();
            return model;
        }

        @Override
        protected void destroyObject(MessageConsumerResources model) throws Exception {
            if (model != null) {
                if (model.getMessageConsumer() != null) {
                    model.getMessageConsumer().close();
                }
                if (model.getSession() != null) {
                    if (model.getSession().getTransacted()) {
                        try {
                            model.getSession().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    model.getSession().close();
                }
            }
        }
    }
}

