/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.ExchangePattern;
import org.apache.camel.MultipleConsumersSupport;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.sjms.SjmsComponent;
import org.apache.camel.component.sjms.SjmsConsumer;
import org.apache.camel.component.sjms.SjmsProducer;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.KeyFormatStrategy;
import org.apache.camel.component.sjms.jms.SessionAcknowledgementType;
import org.apache.camel.component.sjms.producer.InOnlyProducer;
import org.apache.camel.component.sjms.producer.InOutProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sjms", consumerClass=SjmsConsumer.class)
public class SjmsEndpoint
extends DefaultEndpoint
implements MultipleConsumersSupport {
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @UriParam
    private boolean synchronous = true;
    @UriParam
    private boolean transacted;
    @UriParam
    private String namedReplyTo;
    private SessionAcknowledgementType acknowledgementMode = SessionAcknowledgementType.AUTO_ACKNOWLEDGE;
    private boolean topic;
    @UriParam
    private int sessionCount = 1;
    @UriParam
    private int producerCount = 1;
    @UriParam
    private int consumerCount = 1;
    @UriParam
    private long ttl = -1L;
    @UriParam
    private boolean persistent = true;
    @UriParam
    private String durableSubscriptionId;
    @UriParam
    private long responseTimeOut = 5000L;
    @UriParam
    private String messageSelector;
    @UriParam
    private int transactionBatchCount = -1;
    @UriParam
    private long transactionBatchTimeout = 5000L;
    private TransactionCommitStrategy transactionCommitStrategy;
    @UriParam
    private boolean allowNullBody = true;

    public SjmsEndpoint() {
    }

    public SjmsEndpoint(String uri, Component component) {
        super(uri, component);
        if (this.getEndpointUri().indexOf("://queue:") > -1) {
            this.topic = false;
        } else if (this.getEndpointUri().indexOf("://topic:") > -1) {
            this.topic = true;
        } else {
            throw new IllegalArgumentException("Endpoint URI unsupported: " + uri);
        }
    }

    public SjmsComponent getComponent() {
        return (SjmsComponent)super.getComponent();
    }

    protected void doStart() throws Exception {
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
    }

    public Producer createProducer() throws Exception {
        SjmsProducer producer = null;
        producer = this.getExchangePattern().equals((Object)ExchangePattern.InOnly) ? new InOnlyProducer((Endpoint)this) : new InOutProducer(this);
        return producer;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        SjmsConsumer answer = new SjmsConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isMultipleConsumersSupported() {
        return true;
    }

    public boolean isSingleton() {
        return true;
    }

    public String getDestinationName() {
        String answer = this.getEndpointUri().substring(this.getEndpointUri().lastIndexOf(":") + 1);
        if (answer.indexOf("?") > -1) {
            answer = answer.substring(0, answer.lastIndexOf("?"));
        }
        return answer;
    }

    public ConnectionResource getConnectionResource() {
        return this.getComponent().getConnectionResource();
    }

    public HeaderFilterStrategy getSjmsHeaderFilterStrategy() {
        return this.getComponent().getHeaderFilterStrategy();
    }

    public KeyFormatStrategy getJmsKeyFormatStrategy() {
        return this.getComponent().getKeyFormatStrategy();
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }

    public SessionAcknowledgementType getAcknowledgementMode() {
        return this.acknowledgementMode;
    }

    public void setAcknowledgementMode(SessionAcknowledgementType acknowledgementMode) {
        this.acknowledgementMode = acknowledgementMode;
    }

    public boolean isTopic() {
        return this.topic;
    }

    @Deprecated
    public int getSessionCount() {
        return this.sessionCount;
    }

    @Deprecated
    public void setSessionCount(int sessionCount) {
        this.sessionCount = sessionCount;
    }

    public int getProducerCount() {
        return this.producerCount;
    }

    public void setProducerCount(int producerCount) {
        this.producerCount = producerCount;
    }

    public int getConsumerCount() {
        return this.consumerCount;
    }

    public void setConsumerCount(int consumerCount) {
        this.consumerCount = consumerCount;
    }

    public long getTtl() {
        return this.ttl;
    }

    public void setTtl(long ttl) {
        this.ttl = ttl;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getDurableSubscriptionId() {
        return this.durableSubscriptionId;
    }

    public void setDurableSubscriptionId(String durableSubscriptionId) {
        this.durableSubscriptionId = durableSubscriptionId;
    }

    public long getResponseTimeOut() {
        return this.responseTimeOut;
    }

    public void setResponseTimeOut(long responseTimeOut) {
        this.responseTimeOut = responseTimeOut;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public void setMessageSelector(String messageSelector) {
        this.messageSelector = messageSelector;
    }

    public int getTransactionBatchCount() {
        return this.transactionBatchCount;
    }

    public void setTransactionBatchCount(int transactionBatchCount) {
        this.transactionBatchCount = transactionBatchCount;
    }

    public long getTransactionBatchTimeout() {
        return this.transactionBatchTimeout;
    }

    public void setTransactionBatchTimeout(long transactionBatchTimeout) {
        if (transactionBatchTimeout >= 1000L) {
            this.transactionBatchTimeout = transactionBatchTimeout;
        }
    }

    public TransactionCommitStrategy getTransactionCommitStrategy() {
        return this.transactionCommitStrategy;
    }

    public void setTransactionCommitStrategy(TransactionCommitStrategy transactionCommitStrategy) {
        this.transactionCommitStrategy = transactionCommitStrategy;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        if (transacted) {
            this.setAcknowledgementMode(SessionAcknowledgementType.SESSION_TRANSACTED);
        }
        this.transacted = transacted;
    }

    public String getNamedReplyTo() {
        return this.namedReplyTo;
    }

    public void setNamedReplyTo(String namedReplyTo) {
        this.namedReplyTo = namedReplyTo;
        this.setExchangePattern(ExchangePattern.InOut);
    }

    public boolean isAllowNullBody() {
        return this.allowNullBody;
    }

    public void setAllowNullBody(boolean allowNullBody) {
        this.allowNullBody = allowNullBody;
    }
}

