/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.concurrent.ExecutorService;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.ObjectPool;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;

public abstract class SjmsProducer
extends DefaultAsyncProducer {
    private MessageProducerPool producers;
    private final ExecutorService executor;

    public SjmsProducer(Endpoint endpoint) {
        super(endpoint);
        this.executor = endpoint.getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "SjmsProducer");
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getProducers() == null) {
            this.setProducers(new MessageProducerPool());
            this.getProducers().fillPool();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.getProducers() != null) {
            this.getProducers().drainPool();
            this.setProducers(null);
        }
    }

    public abstract MessageProducerResources doCreateProducerModel() throws Exception;

    public abstract void sendMessage(Exchange var1, AsyncCallback var2) throws Exception;

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing Exchange.id:{}", (Object)exchange.getExchangeId());
        }
        try {
            if (!this.isSynchronous()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  Sending message asynchronously: {}", exchange.getIn().getBody());
                }
                this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsProducer.this.sendMessage(exchange, callback);
                        }
                        catch (Exception e) {
                            ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                        }
                    }
                });
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  Sending message synchronously: {}", exchange.getIn().getBody());
                }
                this.sendMessage(exchange, callback);
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing Exchange.id:{}", (Object)(exchange.getExchangeId() + " - FAILED"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.trace("Exception: " + e.getLocalizedMessage(), (Throwable)e);
            }
            exchange.setException((Throwable)e);
        }
        this.log.debug("Processing Exchange.id:{}", (Object)(exchange.getExchangeId() + " - SUCCESS"));
        return this.isSynchronous();
    }

    protected SjmsEndpoint getSjmsEndpoint() {
        return (SjmsEndpoint)this.getEndpoint();
    }

    protected ConnectionResource getConnectionResource() {
        return this.getSjmsEndpoint().getConnectionResource();
    }

    public int getAcknowledgeMode() {
        return this.getSjmsEndpoint().getAcknowledgementMode().intValue();
    }

    public boolean isSynchronous() {
        return this.getSjmsEndpoint().isSynchronous();
    }

    public String getReplyTo() {
        return this.getSjmsEndpoint().getNamedReplyTo();
    }

    public String getDestinationName() {
        return this.getSjmsEndpoint().getDestinationName();
    }

    public void setProducers(MessageProducerPool producers) {
        this.producers = producers;
    }

    public MessageProducerPool getProducers() {
        return this.producers;
    }

    public boolean isTopic() {
        return this.getSjmsEndpoint().isTopic();
    }

    public boolean isEndpointTransacted() {
        return this.getSjmsEndpoint().isTransacted();
    }

    public String getNamedReplyTo() {
        return this.getSjmsEndpoint().getNamedReplyTo();
    }

    public int getProducerCount() {
        return this.getSjmsEndpoint().getProducerCount();
    }

    public int getConsumerCount() {
        return this.getSjmsEndpoint().getConsumerCount();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public long getTtl() {
        return this.getSjmsEndpoint().getTtl();
    }

    public boolean isPersistent() {
        return this.getSjmsEndpoint().isPersistent();
    }

    public long getResponseTimeOut() {
        return this.getSjmsEndpoint().getResponseTimeOut();
    }

    public TransactionCommitStrategy getCommitStrategy() {
        return this.getSjmsEndpoint().getTransactionCommitStrategy();
    }

    protected class MessageProducerResources {
        private final Session session;
        private final MessageProducer messageProducer;
        private final TransactionCommitStrategy commitStrategy;

        public MessageProducerResources(Session session, MessageProducer messageProducer) {
            this(session, messageProducer, null);
        }

        public MessageProducerResources(Session session, MessageProducer messageProducer, TransactionCommitStrategy commitStrategy) {
            this.session = session;
            this.messageProducer = messageProducer;
            this.commitStrategy = commitStrategy;
        }

        public Session getSession() {
            return this.session;
        }

        public MessageProducer getMessageProducer() {
            return this.messageProducer;
        }

        public TransactionCommitStrategy getCommitStrategy() {
            return this.commitStrategy;
        }
    }

    protected class MessageProducerPool
    extends ObjectPool<MessageProducerResources> {
        public MessageProducerPool() {
            super(SjmsProducer.this.getProducerCount());
        }

        @Override
        protected MessageProducerResources createObject() throws Exception {
            return SjmsProducer.this.doCreateProducerModel();
        }

        @Override
        protected void destroyObject(MessageProducerResources model) throws Exception {
            if (model.getMessageProducer() != null) {
                model.getMessageProducer().close();
            }
            if (model.getSession() != null) {
                try {
                    if (model.getSession().getTransacted()) {
                        try {
                            model.getSession().rollback();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    model.getSession().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

