/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.ObjectPool;
import org.apache.camel.util.ObjectHelper;

public class ConnectionFactoryResource
extends ObjectPool<Connection>
implements ConnectionResource {
    private ConnectionFactory connectionFactory;
    private String username;
    private String password;
    private String clientId;

    public ConnectionFactoryResource() {
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory) {
        this(poolSize, connectionFactory, null, null);
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory, String username, String password) {
        super(poolSize);
        this.connectionFactory = connectionFactory;
        this.username = username;
        this.password = password;
    }

    public ConnectionFactoryResource(int poolSize, ConnectionFactory connectionFactory, String username, String password, String connectionId) {
        super(poolSize);
        this.connectionFactory = connectionFactory;
        this.username = username;
        this.password = password;
        this.clientId = connectionId;
    }

    @Override
    public Connection borrowConnection() throws Exception {
        return (Connection)this.borrowObject();
    }

    @Override
    public Connection borrowConnection(long timeout) throws Exception {
        return (Connection)this.borrowObject(timeout);
    }

    @Override
    public void returnConnection(Connection connection) throws Exception {
        this.returnObject(connection);
    }

    @Override
    protected Connection createObject() throws Exception {
        Connection connection = null;
        if (this.connectionFactory != null) {
            connection = this.getUsername() != null && this.getPassword() != null ? this.connectionFactory.createConnection(this.getUsername(), this.getPassword()) : this.connectionFactory.createConnection();
        }
        if (connection != null) {
            if (ObjectHelper.isNotEmpty((Object)this.getClientId())) {
                connection.setClientID(this.getClientId());
            }
            connection.start();
        }
        return connection;
    }

    @Override
    protected void destroyObject(Connection connection) throws Exception {
        if (connection != null) {
            connection.stop();
            connection.close();
        }
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }
}

