/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Connection;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XASession;
import javax.transaction.xa.XAResource;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.component.sjms.jms.ObjectPool;
import org.apache.camel.component.sjms.jms.SessionAcknowledgementType;

public class SessionPool
extends ObjectPool<Session> {
    private ConnectionResource connectionResource;
    private boolean transacted;
    private SessionAcknowledgementType acknowledgeMode = SessionAcknowledgementType.AUTO_ACKNOWLEDGE;

    public SessionPool(int poolSize, ConnectionResource connectionResource) {
        super(poolSize);
        this.connectionResource = connectionResource;
    }

    public SessionPool(int poolSize) {
        super(poolSize);
    }

    @Override
    protected Session createObject() throws Exception {
        Session session = null;
        Connection connection = this.getConnectionResource().borrowConnection(5000L);
        if (connection != null) {
            if (this.transacted) {
                session = connection.createSession(this.transacted, 1);
            } else {
                switch (this.acknowledgeMode) {
                    case CLIENT_ACKNOWLEDGE: {
                        session = connection.createSession(this.transacted, 2);
                        break;
                    }
                    case DUPS_OK_ACKNOWLEDGE: {
                        session = connection.createSession(this.transacted, 3);
                        break;
                    }
                    case AUTO_ACKNOWLEDGE: {
                        session = connection.createSession(this.transacted, 1);
                        break;
                    }
                }
            }
        }
        this.getConnectionResource().returnConnection(connection);
        return session;
    }

    @Override
    protected void destroyObject(Session session) throws Exception {
        session.setMessageListener(null);
        if (this.transacted) {
            try {
                session.rollback();
            }
            catch (JMSException e) {
                this.logger.warn("Caught exception trying rollback() when putting session back into the pool, will invalidate. " + (Object)((Object)e), (Throwable)e);
            }
        }
        if (session != null) {
            session.close();
            session = null;
        }
    }

    public final SessionAcknowledgementType getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public final void setAcknowledgeMode(SessionAcknowledgementType acknowledgeMode) {
        this.acknowledgeMode = acknowledgeMode;
    }

    public final boolean isTransacted() {
        return this.transacted;
    }

    public final void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    public ConnectionResource getConnectionResource() {
        return this.connectionResource;
    }

    protected XAResource createXaResource(XASession session) throws JMSException {
        return session.getXAResource();
    }
}

