/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.tx;

import javax.jms.Session;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.tx.DefaultTransactionCommitStrategy;
import org.apache.camel.spi.Synchronization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionTransactionSynchronization
implements Synchronization {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Session session;
    private final TransactionCommitStrategy commitStrategy;

    public SessionTransactionSynchronization(Session session, TransactionCommitStrategy commitStrategy) {
        this.session = session;
        this.commitStrategy = commitStrategy == null ? new DefaultTransactionCommitStrategy() : commitStrategy;
    }

    public void onFailure(Exchange exchange) {
        try {
            if (this.commitStrategy.rollback(exchange)) {
                this.log.debug("Processing failure of Exchange id:{}", (Object)exchange.getExchangeId());
                if (this.session != null && this.session.getTransacted()) {
                    this.session.rollback();
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to rollback the session: {}", (Object)e.getMessage());
        }
    }

    public void onComplete(Exchange exchange) {
        try {
            if (this.commitStrategy.commit(exchange)) {
                this.log.debug("Processing completion of Exchange id:{}", (Object)exchange.getExchangeId());
                if (this.session != null && this.session.getTransacted()) {
                    this.session.commit();
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Failed to commit the session: {}", (Object)e.getMessage());
            exchange.setException((Throwable)e);
        }
    }
}

