/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import javax.jms.Destination;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.Topic;
import org.apache.camel.util.ObjectHelper;

public final class JmsObjectFactory {
    private JmsObjectFactory() {
    }

    public static MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String durableSubscriptionId) throws Exception {
        return JmsObjectFactory.createMessageConsumer(session, destination, messageSelector, topic, durableSubscriptionId, false);
    }

    public static MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String durableSubscriptionId, boolean noLocal) throws Exception {
        Object messageConsumer = topic ? (ObjectHelper.isNotEmpty((Object)durableSubscriptionId) ? (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createDurableSubscriber((Topic)destination, durableSubscriptionId, messageSelector, noLocal) : session.createDurableSubscriber((Topic)destination, durableSubscriptionId)) : (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createConsumer(destination, messageSelector, noLocal) : session.createConsumer(destination))) : (ObjectHelper.isNotEmpty((Object)messageSelector) ? session.createConsumer(destination, messageSelector) : session.createConsumer(destination));
        return messageConsumer;
    }

    public static MessageProducer createMessageProducer(Session session, Destination destination, boolean persistent, long ttl) throws Exception {
        MessageProducer messageProducer = session.createProducer(destination);
        messageProducer.setDeliveryMode(persistent ? 2 : 1);
        if (ttl > 0L) {
            messageProducer.setTimeToLive(ttl);
        }
        return messageProducer;
    }
}

