/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.camel.AsyncCallback;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.sjms.MessageProducerResources;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.TransactionCommitStrategy;
import org.apache.camel.component.sjms.jms.ConnectionResource;
import org.apache.camel.impl.DefaultAsyncProducer;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;

public abstract class SjmsProducer
extends DefaultAsyncProducer {
    private GenericObjectPool<MessageProducerResources> producers;
    private ExecutorService executor;
    private Future<?> asyncStart;

    public SjmsProducer(Endpoint endpoint) {
        super(endpoint);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.executor = this.getEndpoint().getCamelContext().getExecutorServiceManager().newDefaultThreadPool((Object)this, "SjmsProducer");
        if (this.getProducers() == null) {
            this.setProducers((GenericObjectPool<MessageProducerResources>)new GenericObjectPool((PoolableObjectFactory)new MessageProducerResourcesFactory()));
            this.getProducers().setMaxActive(this.getProducerCount());
            this.getProducers().setMaxIdle(this.getProducerCount());
            this.getProducers().setLifo(false);
            if (this.getEndpoint().isPrefillPool()) {
                if (this.getEndpoint().isAsyncStartListener()) {
                    this.asyncStart = this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                SjmsProducer.this.fillProducersPool();
                            }
                            catch (Throwable e) {
                                SjmsProducer.this.log.warn("Error filling producer pool for destination: " + SjmsProducer.this.getDestinationName() + ". This exception will be ignored.", e);
                            }
                        }

                        public String toString() {
                            return "AsyncStartListenerTask[" + SjmsProducer.this.getDestinationName() + "]";
                        }
                    });
                } else {
                    this.fillProducersPool();
                }
            }
        }
    }

    private void fillProducersPool() throws Exception {
        while (this.producers.getNumIdle() < this.producers.getMaxIdle()) {
            this.producers.addObject();
        }
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.asyncStart != null && !this.asyncStart.isDone()) {
            this.asyncStart.cancel(true);
        }
        if (this.getProducers() != null) {
            if (this.getEndpoint().isAsyncStopListener()) {
                this.getEndpoint().getComponent().getAsyncStartStopExecutorService().submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsProducer.this.getProducers().close();
                            SjmsProducer.this.setProducers(null);
                        }
                        catch (Throwable e) {
                            SjmsProducer.this.log.warn("Error closing producers on destination: " + SjmsProducer.this.getDestinationName() + ". This exception will be ignored.", e);
                        }
                    }

                    public String toString() {
                        return "AsyncStopListenerTask[" + SjmsProducer.this.getDestinationName() + "]";
                    }
                });
            } else {
                this.getProducers().close();
                this.setProducers(null);
            }
        }
        if (this.executor != null) {
            this.getEndpoint().getCamelContext().getExecutorServiceManager().shutdownGraceful(this.executor);
        }
    }

    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    public abstract MessageProducerResources doCreateProducerModel() throws Exception;

    public abstract void sendMessage(Exchange var1, AsyncCallback var2, MessageProducerResources var3) throws Exception;

    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Processing Exchange.id:{}", (Object)exchange.getExchangeId());
        }
        try {
            final MessageProducerResources producer = (MessageProducerResources)this.getProducers().borrowObject();
            if (producer == null) {
                exchange.setException((Throwable)new Exception("Unable to send message: connection not available"));
            } else if (!this.isSynchronous()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  Sending message asynchronously: {}", exchange.getIn().getBody());
                }
                this.getExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SjmsProducer.this.sendMessage(exchange, callback, producer);
                        }
                        catch (Exception e) {
                            ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                        }
                    }
                });
            } else {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("  Sending message synchronously: {}", exchange.getIn().getBody());
                }
                this.sendMessage(exchange, callback, producer);
            }
        }
        catch (Exception e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Processing Exchange.id:{}", (Object)(exchange.getExchangeId() + " - FAILED"));
            }
            if (this.log.isDebugEnabled()) {
                this.log.trace("Exception: " + e.getLocalizedMessage(), (Throwable)e);
            }
            exchange.setException((Throwable)e);
        }
        this.log.debug("Processing Exchange.id:{}", (Object)(exchange.getExchangeId() + " - SUCCESS"));
        return this.isSynchronous();
    }

    protected ConnectionResource getConnectionResource() {
        return this.getEndpoint().getConnectionResource();
    }

    public int getAcknowledgeMode() {
        return this.getEndpoint().getAcknowledgementMode().intValue();
    }

    public boolean isSynchronous() {
        return this.getEndpoint().isSynchronous();
    }

    public String getReplyTo() {
        return this.getEndpoint().getNamedReplyTo();
    }

    public String getDestinationName() {
        return this.getEndpoint().getDestinationName();
    }

    public void setProducers(GenericObjectPool<MessageProducerResources> producers) {
        this.producers = producers;
    }

    public GenericObjectPool<MessageProducerResources> getProducers() {
        return this.producers;
    }

    public boolean isTopic() {
        return this.getEndpoint().isTopic();
    }

    public boolean isEndpointTransacted() {
        return this.getEndpoint().isTransacted();
    }

    public String getNamedReplyTo() {
        return this.getEndpoint().getNamedReplyTo();
    }

    public int getProducerCount() {
        return this.getEndpoint().getProducerCount();
    }

    public int getConsumerCount() {
        return this.getEndpoint().getConsumerCount();
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public long getTtl() {
        return this.getEndpoint().getTtl();
    }

    public boolean isPersistent() {
        return this.getEndpoint().isPersistent();
    }

    public long getResponseTimeOut() {
        return this.getEndpoint().getResponseTimeOut();
    }

    public TransactionCommitStrategy getCommitStrategy() {
        return this.getEndpoint().getTransactionCommitStrategy();
    }

    protected class MessageProducerResourcesFactory
    extends BasePoolableObjectFactory<MessageProducerResources> {
        protected MessageProducerResourcesFactory() {
        }

        public MessageProducerResources makeObject() throws Exception {
            return SjmsProducer.this.doCreateProducerModel();
        }

        public void destroyObject(MessageProducerResources model) throws Exception {
            if (model.getMessageProducer() != null) {
                model.getMessageProducer().close();
            }
            if (model.getSession() != null) {
                try {
                    if (model.getSession().getTransacted()) {
                        try {
                            model.getSession().rollback();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    model.getSession().close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

