/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Converter;
import org.snmp4j.PDU;
import org.snmp4j.smi.VariableBinding;

@Converter
public final class SnmpConverters {
    public static final String SNMP_TAG = "snmp";
    public static final String ENTRY_TAG = "entry";
    public static final String OID_TAG = "oid";
    public static final String VALUE_TAG = "value";
    private static final String SNMP_TAG_OPEN = "<snmp>";
    private static final String SNMP_TAG_CLOSE = "</snmp>";
    private static final String ENTRY_TAG_OPEN = "<entry>";
    private static final String ENTRY_TAG_CLOSE = "</entry>";
    private static final String OID_TAG_OPEN = "<oid>";
    private static final String OID_TAG_CLOSE = "</oid>";
    private static final String VALUE_TAG_OPEN = "<value>";
    private static final String VALUE_TAG_CLOSE = "</value>";

    private SnmpConverters() {
    }

    @Converter
    public static String toString(PDU pdu) {
        StringBuffer sb = new StringBuffer();
        sb.append(SNMP_TAG_OPEN);
        for (Object o : pdu.getVariableBindings()) {
            VariableBinding b = (VariableBinding)o;
            sb.append(ENTRY_TAG_OPEN);
            sb.append(OID_TAG_OPEN);
            sb.append(b.getOid().toString());
            sb.append(OID_TAG_CLOSE);
            sb.append(VALUE_TAG_OPEN);
            sb.append(b.getVariable().toString());
            sb.append(VALUE_TAG_CLOSE);
            sb.append(ENTRY_TAG_CLOSE);
        }
        sb.append(SNMP_TAG_CLOSE);
        return sb.toString();
    }
}

