/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.impl.ScheduledPollConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.mp.MPv3;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpOIDPoller
extends ScheduledPollConsumer
implements ResponseListener {
    private static final transient Log LOG = LogFactory.getLog(SnmpOIDPoller.class);
    private Address targetAddress;
    private TransportMapping transport;
    private Snmp snmp;
    private USM usm;
    private CommunityTarget target;
    private PDU pdu;
    private SnmpEndpoint endpoint;

    public SnmpOIDPoller(SnmpEndpoint endpoint, Processor processor) {
        super((DefaultEndpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.setDelay(endpoint.getDelay() * 1000);
    }

    protected void doStart() throws Exception {
        super.doStart();
        LOG.debug((Object)"Activating oid poller");
        this.targetAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        this.transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp(this.transport);
        this.usm = new USM(SecurityProtocols.getInstance(), new OctetString(MPv3.createLocalEngineID()), 0);
        SecurityModels.getInstance().addSecurityModel((SecurityModel)this.usm);
        this.target = new CommunityTarget();
        this.target.setCommunity(new OctetString(this.endpoint.getSnmpCommunity()));
        this.target.setAddress(this.targetAddress);
        this.target.setRetries(this.endpoint.getRetries());
        this.target.setTimeout((long)this.endpoint.getTimeout());
        this.target.setVersion(this.endpoint.getSnmpVersion());
        this.pdu = new PDU();
        this.transport.listen();
    }

    protected void doStop() throws Exception {
        if (this.transport.isListening()) {
            this.transport.close();
        }
        super.doStop();
    }

    protected void poll() throws Exception {
        this.pdu.clear();
        this.pdu.setType(-96);
        for (OID oid : this.endpoint.getOids()) {
            this.pdu.add(new VariableBinding(oid));
        }
        this.snmp.send(this.pdu, (Target)this.target, null, (ResponseListener)this);
    }

    public void onResponse(ResponseEvent event) {
        ((Snmp)event.getSource()).cancel(event.getRequest(), (ResponseListener)this);
        if (event.getRequest() == null || event.getResponse() == null) {
            LOG.debug((Object)("Received invalid snmp event. Request: " + event.getRequest() + " / Response: " + event.getResponse()));
            return;
        }
        PDU pdu = event.getResponse();
        this.processPDU(pdu);
    }

    public void processPDU(PDU pdu) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received response event for " + this.endpoint.getAddress() + " : " + pdu));
        }
        Exchange exchange = this.endpoint.createExchange(pdu);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception ex) {
            exchange.setException(ex);
        }
    }

    public CommunityTarget getTarget() {
        return this.target;
    }

    public void setTarget(CommunityTarget target) {
        this.target = target;
    }
}

