/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.snmp.SnmpEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.TransportMapping;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SnmpTrapConsumer
extends DefaultConsumer
implements CommandResponder {
    private static final Log LOG = LogFactory.getLog(SnmpTrapConsumer.class);
    private SnmpEndpoint endpoint;
    private Address listenGenericAddress;
    private Snmp snmp;
    private TransportMapping transport;

    public SnmpTrapConsumer(SnmpEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Starting trap consumer on " + this.endpoint.getAddress()));
        }
        this.listenGenericAddress = GenericAddress.parse((String)this.endpoint.getAddress());
        this.transport = new DefaultUdpTransportMapping((UdpAddress)this.listenGenericAddress);
        this.snmp = new Snmp(this.transport);
        this.snmp.addCommandResponder((CommandResponder)this);
        this.transport.listen();
    }

    protected void doStop() throws Exception {
        if (this.transport != null && this.transport.isListening()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Stopping trap consumer on " + this.endpoint.getAddress()));
            }
            this.transport.close();
        }
        super.doStop();
    }

    public void processPdu(CommandResponderEvent event) {
        PDU pdu = event.getPDU();
        if (pdu != null) {
            this.processPDU(pdu);
        } else {
            LOG.debug((Object)("Received invalid trap PDU: " + pdu));
        }
    }

    public void processPDU(PDU pdu) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Received trap event for " + this.endpoint.getAddress() + " : " + pdu));
        }
        Exchange exchange = this.endpoint.createExchange(pdu);
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception ex) {
            exchange.setException((Throwable)ex);
        }
    }
}

