/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.net.URI;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.snmp.OIDList;
import org.apache.camel.component.snmp.SnmpActionType;
import org.apache.camel.component.snmp.SnmpComponent;
import org.apache.camel.component.snmp.SnmpMessage;
import org.apache.camel.component.snmp.SnmpOIDPoller;
import org.apache.camel.component.snmp.SnmpTrapConsumer;
import org.apache.camel.impl.DefaultExchange;
import org.apache.camel.impl.DefaultPollingEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snmp4j.PDU;

public class SnmpEndpoint
extends DefaultPollingEndpoint {
    public static final String DEFAULT_COMMUNITY = "public";
    public static final int DEFAULT_SNMP_VERSION = 0;
    public static final int DEFAULT_SNMP_RETRIES = 2;
    public static final int DEFAULT_SNMP_TIMEOUT = 1500;
    private static final Logger LOG = LoggerFactory.getLogger(SnmpEndpoint.class);
    private OIDList oids = new OIDList();
    private String address;
    private String protocol = "udp";
    private int retries = 2;
    private int timeout = 1500;
    private int snmpVersion = 0;
    private String snmpCommunity = "public";
    private SnmpActionType type;
    private int delay = 60;

    public SnmpEndpoint(String uri, SnmpComponent component) {
        super(uri, (Component)component);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (this.type == SnmpActionType.TRAP) {
            return new SnmpTrapConsumer(this, processor);
        }
        if (this.type == SnmpActionType.POLL) {
            return new SnmpOIDPoller(this, processor);
        }
        throw new IllegalArgumentException("The type '" + (Object)((Object)this.type) + "' is not valid!");
    }

    public Producer createProducer() throws Exception {
        throw new UnsupportedOperationException("SnmpProducer is not implemented");
    }

    public boolean isSingleton() {
        return true;
    }

    public Exchange createExchange(PDU pdu) {
        return this.createExchange(this.getExchangePattern(), pdu);
    }

    private Exchange createExchange(ExchangePattern pattern, PDU pdu) {
        DefaultExchange exchange = new DefaultExchange((Endpoint)this, pattern);
        exchange.setIn((Message)new SnmpMessage(pdu));
        return exchange;
    }

    public void initiate() throws Exception {
        URI uri = URI.create(this.getEndpointUri());
        String host = uri.getHost();
        int port = uri.getPort();
        if (host == null || host.trim().length() < 1) {
            host = "127.0.0.1";
        }
        if (port == -1) {
            port = this.getType() == SnmpActionType.POLL ? 161 : 162;
        }
        String address = String.format("%s:%s/%d", this.getProtocol(), host, port);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using snmp address " + address);
        }
        this.setAddress(address);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int updateEvery) {
        this.delay = updateEvery;
    }

    public SnmpActionType getType() {
        return this.type;
    }

    public void setType(SnmpActionType type) {
        this.type = type;
    }

    public OIDList getOids() {
        return this.oids;
    }

    public void setOids(OIDList oids) {
        this.oids = oids;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public int getRetries() {
        return this.retries;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getSnmpVersion() {
        return this.snmpVersion;
    }

    public void setSnmpVersion(int snmpVersion) {
        this.snmpVersion = snmpVersion;
    }

    public String getSnmpCommunity() {
        return this.snmpCommunity;
    }

    public void setSnmpCommunity(String snmpCommunity) {
        this.snmpCommunity = snmpCommunity;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String toString() {
        return "SnmpEndpoint[" + this.address + "]";
    }
}

