/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.snmp;

import java.util.StringTokenizer;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.snmp.OIDList;
import org.snmp4j.PDU;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;

@Converter
public final class SnmpConverters {
    public static final String SNMP_TAG = "snmp";
    public static final String ENTRY_TAG = "entry";
    public static final String OID_TAG = "oid";
    public static final String VALUE_TAG = "value";
    private static final String SNMP_TAG_OPEN = "<snmp>";
    private static final String SNMP_TAG_CLOSE = "</snmp>";
    private static final String ENTRY_TAG_OPEN = "<entry>";
    private static final String ENTRY_TAG_CLOSE = "</entry>";
    private static final String OID_TAG_OPEN = "<oid>";
    private static final String OID_TAG_CLOSE = "</oid>";
    private static final String VALUE_TAG_OPEN = "<value>";
    private static final String VALUE_TAG_CLOSE = "</value>";

    private SnmpConverters() {
    }

    @Converter
    public static OIDList toOIDList(String s, Exchange exchange) {
        OIDList list = new OIDList();
        if (s != null && s.indexOf(",") != -1) {
            StringTokenizer strTok = new StringTokenizer(s, ",");
            while (strTok.hasMoreTokens()) {
                String tok = strTok.nextToken();
                if (tok == null || tok.trim().length() <= 0) continue;
                list.add(new OID(tok.trim()));
            }
        } else if (s != null) {
            list.add(new OID(s.trim()));
        }
        return list;
    }

    @Converter
    public static String toString(PDU pdu) {
        StringBuilder sb = new StringBuilder();
        sb.append(SNMP_TAG_OPEN);
        for (Object o : pdu.getVariableBindings()) {
            VariableBinding b = (VariableBinding)o;
            sb.append(ENTRY_TAG_OPEN);
            sb.append(OID_TAG_OPEN);
            sb.append(b.getOid().toString());
            sb.append(OID_TAG_CLOSE);
            sb.append(VALUE_TAG_OPEN);
            sb.append(SnmpConverters.getXmlSafeString(b.getVariable().toString()));
            sb.append(VALUE_TAG_CLOSE);
            sb.append(ENTRY_TAG_CLOSE);
        }
        sb.append(SNMP_TAG_CLOSE);
        return sb.toString();
    }

    private static String getXmlSafeString(String string) {
        return string.replaceAll("<", "&lt;").replaceAll(">", "&gt;").replaceAll("&", "&amp;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }
}

