/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import javax.jws.WebMethod;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.bean.BeanInvocation;
import org.apache.camel.converter.jaxb.JaxbDataFormat;
import org.apache.camel.dataformat.soap.name.ElementNameStrategy;
import org.apache.camel.dataformat.soap.name.TypeNameStrategy;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Detail;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;
import org.xmlsoap.schemas.soap.envelope.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoapJaxbDataFormat
extends JaxbDataFormat {
    private static final String SOAP_PACKAGE_NAME = Envelope.class.getPackage().getName();
    private static final QName FAULT_CODE_SERVER = new QName("http://www.w3.org/2003/05/soap-envelope", "Receiver");
    private ElementNameStrategy elementNameStrategy;
    private String elementNameStrategyRef;

    public SoapJaxbDataFormat() {
    }

    public SoapJaxbDataFormat(String contextPath) {
        super(contextPath);
    }

    public SoapJaxbDataFormat(String contextPath, ElementNameStrategy elementNameStrategy) {
        this(contextPath);
        this.elementNameStrategy = elementNameStrategy;
    }

    public void setElementNameStrategy(Object nameStrategy) {
        if (nameStrategy instanceof ElementNameStrategy) {
            this.elementNameStrategy = (ElementNameStrategy)nameStrategy;
        } else {
            new IllegalArgumentException("The argument for setElementNameStrategy should be subClass of " + ElementNameStrategy.class.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkElementNameStrategy(Exchange exchange) {
        if (this.elementNameStrategy == null) {
            SoapJaxbDataFormat soapJaxbDataFormat = this;
            synchronized (soapJaxbDataFormat) {
                if (this.elementNameStrategy != null) {
                    return;
                }
                this.elementNameStrategy = this.elementNameStrategyRef != null ? (ElementNameStrategy)exchange.getContext().getRegistry().lookup(this.elementNameStrategyRef, ElementNameStrategy.class) : new TypeNameStrategy();
            }
        }
    }

    public void marshal(Exchange exchange, Object inputObject, OutputStream stream) throws IOException {
        BeanInvocation beanInvocation;
        WebMethod webMethod;
        this.checkElementNameStrategy(exchange);
        String soapAction = (String)exchange.getIn().getHeader("CamelSoapAction");
        if (soapAction == null && inputObject instanceof BeanInvocation && (webMethod = (beanInvocation = (BeanInvocation)inputObject).getMethod().getAnnotation(WebMethod.class)) != null && webMethod.action() != null) {
            soapAction = webMethod.action();
        }
        Body body = new Body();
        Throwable exception = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
        if (exception == null) {
            exception = (Throwable)exchange.getIn().getHeader("CamelExceptionCaught", Throwable.class);
        }
        Object content = exception != null ? this.createFaultFromException(exception) : this.createBodyContentFromObject(inputObject, soapAction);
        body.getAny().add(content);
        Envelope envelope = new Envelope();
        envelope.setBody(body);
        JAXBElement<Envelope> envelopeEl = new ObjectFactory().createEnvelope(envelope);
        super.marshal(exchange, envelopeEl, stream);
    }

    private JAXBElement<?> createBodyContentFromObject(Object inputObject, String soapAction) {
        Object graph;
        if (inputObject instanceof BeanInvocation) {
            BeanInvocation bi = (BeanInvocation)inputObject;
            if (bi.getArgs().length > 1) {
                throw new RuntimeCamelException("SoapDataFormat does not work with Beaninvocations that contain more than 1 parameter");
            }
            graph = bi.getArgs().length == 1 ? bi.getArgs()[0] : null;
        } else {
            graph = inputObject;
        }
        QName name = this.elementNameStrategy.findQNameForSoapActionOrType(soapAction, graph.getClass());
        return new JAXBElement(name, graph.getClass(), graph);
    }

    private JAXBElement<Fault> createFaultFromException(Throwable exception) {
        WebFault webFault = exception.getClass().getAnnotation(WebFault.class);
        if (webFault == null || webFault.targetNamespace() == null) {
            throw new RuntimeException("The exception " + exception.getClass().getName() + " needs to have an WebFault annotation with name and targetNamespace");
        }
        QName name = new QName(webFault.targetNamespace(), webFault.name());
        Object faultObject = null;
        try {
            Method method = exception.getClass().getMethod("getFaultInfo", new Class[0]);
            faultObject = method.invoke((Object)exception, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Exception while trying to get fault details", (Throwable)e);
        }
        Fault fault = new Fault();
        fault.setFaultcode(FAULT_CODE_SERVER);
        fault.setFaultstring(exception.getMessage());
        Detail detailEl = new ObjectFactory().createDetail();
        JAXBElement faultDetailContent = new JAXBElement(name, faultObject.getClass(), faultObject);
        detailEl.getAny().add(faultDetailContent);
        fault.setDetail(detailEl);
        return new ObjectFactory().createFault(fault);
    }

    public Object unmarshal(Exchange exchange, InputStream stream) throws IOException {
        Object rootObject = JAXBIntrospector.getValue((Object)super.unmarshal(exchange, stream));
        if (rootObject.getClass() != Envelope.class) {
            throw new RuntimeCamelException("Expected Soap Envelope but got " + rootObject.getClass());
        }
        Envelope envelope = (Envelope)rootObject;
        Object payloadEl = envelope.getBody().getAny().get(0);
        Object payload = JAXBIntrospector.getValue((Object)payloadEl);
        if (payload instanceof Fault) {
            Exception exception = this.createExceptionFromFault((Fault)payload);
            exchange.setException((Throwable)exception);
            return null;
        }
        return this.isIgnoreJAXBElement() ? payload : payloadEl;
    }

    private Exception createExceptionFromFault(Fault fault) {
        List<Object> detailList = fault.getDetail().getAny();
        String message = fault.getFaultstring();
        if (detailList.size() == 0) {
            return new RuntimeCamelException(message);
        }
        JAXBElement detailEl = (JAXBElement)detailList.get(0);
        Class<? extends Exception> exceptionClass = this.elementNameStrategy.findExceptionForFaultName(detailEl.getName());
        try {
            Constructor<? extends Exception> messageContructor = exceptionClass.getConstructor(String.class);
            Object detail = JAXBIntrospector.getValue((Object)detailEl);
            try {
                Constructor<? extends Exception> constructor = exceptionClass.getConstructor(String.class, detail.getClass());
                return constructor.newInstance(message, detail);
            }
            catch (NoSuchMethodException e) {
                return messageContructor.newInstance(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    protected JAXBContext createContext() throws JAXBException {
        if (this.getContextPath() != null) {
            return JAXBContext.newInstance((String)(SOAP_PACKAGE_NAME + ":" + this.getContextPath()));
        }
        return JAXBContext.newInstance((Class[])new Class[0]);
    }

    public void setElementNameStrategy(ElementNameStrategy elementNameStrategy) {
        this.elementNameStrategy = elementNameStrategy;
    }
}

