/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.javaconfig;

import java.util.List;
import org.apache.camel.CamelContext;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.config.java.annotation.Bean;
import org.springframework.config.java.annotation.Configuration;
import org.springframework.config.java.support.ConfigurationSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Configuration
public abstract class CamelConfiguration
extends ConfigurationSupport {
    @Bean
    public CamelBeanPostProcessor camelBeanPostProcessor() throws Exception {
        CamelBeanPostProcessor answer = new CamelBeanPostProcessor();
        CamelContext camelContext = (CamelContext)this.getBean(CamelContext.class);
        answer.setCamelContext(camelContext);
        return answer;
    }

    @Bean
    public CamelContext camelContext() throws Exception {
        CamelContext camelContext = this.createCamelContext();
        this.setupCamelContext(camelContext);
        List<RouteBuilder> routes = this.routes();
        for (RouteBuilder route : routes) {
            camelContext.addRoutes((RoutesBuilder)route);
        }
        return camelContext;
    }

    protected void setupCamelContext(CamelContext camelContext) throws Exception {
    }

    protected CamelContext createCamelContext() throws Exception {
        return new SpringCamelContext(this.getApplicationContext());
    }

    public abstract List<RouteBuilder> routes();
}

