/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.javaconfig.test;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.annotation.AnnotationConfigUtils;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.ContextLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaConfigContextLoader
implements ContextLoader {
    protected final Log logger = LogFactory.getLog(this.getClass());

    public String[] processLocations(Class<?> clazz, String ... locations) {
        return locations;
    }

    public ApplicationContext loadContext(String ... locations) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Creating a JavaConfigApplicationContext for " + Arrays.asList(locations)));
        }
        AnnotationConfigApplicationContext context = new AnnotationConfigApplicationContext();
        ArrayList configClasses = new ArrayList();
        ArrayList<String> basePackages = new ArrayList<String>();
        for (String location : locations) {
            try {
                Class<?> aClass = this.getClass().getClassLoader().loadClass(location);
                configClasses.add(aClass);
            }
            catch (ClassNotFoundException e) {
                if (Package.getPackage(location) == null) {
                    throw new IllegalArgumentException(String.format("A non-existent class or package name was specified: [%s]", location));
                }
                basePackages.add(location);
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Setting config classes to " + configClasses));
            this.logger.debug((Object)("Setting base packages to " + basePackages));
        }
        for (Class clazz : configClasses) {
            context.register(new Class[]{clazz});
        }
        for (String string : basePackages) {
            context.scan(new String[]{string});
        }
        context.refresh();
        GenericApplicationContext gac = new GenericApplicationContext((ApplicationContext)context);
        AnnotationConfigUtils.registerAnnotationConfigProcessors((BeanDefinitionRegistry)gac);
        for (String bppName : context.getBeanFactory().getBeanNamesForType(BeanPostProcessor.class)) {
            gac.registerBeanDefinition(bppName, context.getBeanFactory().getBeanDefinition(bppName));
        }
        gac.refresh();
        gac.registerShutdownHook();
        return gac;
    }
}

