/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.Map;
import javax.xml.transform.TransformerFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.builder.xml.XsltBuilder;
import org.apache.camel.component.ResourceBasedComponent;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.ProcessorEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.springframework.core.io.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltComponent
extends ResourceBasedComponent {
    private XmlConverter xmlConverter;

    public XmlConverter getXmlConverter() {
        return this.xmlConverter;
    }

    public void setXmlConverter(XmlConverter xmlConverter) {
        this.xmlConverter = xmlConverter;
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        String transformerFactoryName;
        Resource resource = this.resolveMandatoryResource(remaining);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)((Object)((Object)this) + " using schema resource: " + resource));
        }
        XsltBuilder xslt = (XsltBuilder)this.getCamelContext().getInjector().newInstance(XsltBuilder.class);
        XmlConverter converter = null;
        String converterName = (String)this.getAndRemoveParameter(parameters, "converter", String.class);
        if (converterName != null) {
            converter = (XmlConverter)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)converterName, XmlConverter.class);
        }
        if (converter == null) {
            converter = this.getXmlConverter();
        }
        if (converter != null) {
            xslt.setConverter(converter);
        }
        String transformerFactoryClassName = (String)this.getAndRemoveParameter(parameters, "transformerFactoryClass", String.class);
        TransformerFactory factory = null;
        if (transformerFactoryClassName != null) {
            Class factoryClass = this.getCamelContext().getClassResolver().resolveClass(transformerFactoryClassName, XsltComponent.class.getClassLoader());
            if (factoryClass != null) {
                factory = (TransformerFactory)this.getCamelContext().getInjector().newInstance(factoryClass);
            } else {
                this.log.warn((Object)("Cannot find the TransformerFactoryClass with the class name: " + transformerFactoryClassName));
            }
        }
        if ((transformerFactoryName = (String)this.getAndRemoveParameter(parameters, "transformerFactory", String.class)) != null) {
            factory = (TransformerFactory)CamelContextHelper.mandatoryLookup((CamelContext)this.getCamelContext(), (String)transformerFactoryName, TransformerFactory.class);
        }
        if (factory != null) {
            xslt.getConverter().setTransformerFactory(factory);
        }
        xslt.setTransformerInputStream(resource.getInputStream());
        this.configureXslt(xslt, uri, remaining, parameters);
        return new ProcessorEndpoint(uri, (Component)this, (Processor)xslt);
    }

    protected void configureXslt(XsltBuilder xslt, String uri, String remaining, Map<String, Object> parameters) throws Exception {
        this.setProperties(xslt, parameters);
    }
}

