/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.List;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.osgi.CompositeRegistry;
import org.apache.camel.osgi.OsgiAnnotationTypeConverterLoader;
import org.apache.camel.osgi.OsgiComponentResolver;
import org.apache.camel.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.osgi.OsgiLanguageResolver;
import org.apache.camel.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.osgi.OsgiServiceRegistry;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.springframework.osgi.context.BundleContextAware;

public class CamelContextFactory
implements BundleContextAware {
    private static final transient Log LOG = LogFactory.getLog(CamelContextFactory.class);
    private BundleContext bundleContext;

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public void setBundleContext(BundleContext bundleContext) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using BundleContext: " + bundleContext));
        }
        this.bundleContext = bundleContext;
    }

    protected DefaultCamelContext newCamelContext() {
        return new DefaultCamelContext();
    }

    public DefaultCamelContext createContext() {
        LOG.debug((Object)"Creating DefaultCamelContext");
        DefaultCamelContext context = this.newCamelContext();
        if (this.bundleContext != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Using OSGI resolvers");
            }
            this.updateRegistry(context);
            LOG.debug((Object)"Using OsgiFactoryFinderResolver");
            context.setFactoryFinderResolver((FactoryFinderResolver)new OsgiFactoryFinderResolver());
            LOG.debug((Object)"Using OsgiPackageScanClassResolver");
            context.setPackageScanClassResolver((PackageScanClassResolver)new OsgiPackageScanClassResolver(this.bundleContext));
            LOG.debug((Object)"Using OsgiComponentResolver");
            context.setComponentResolver((ComponentResolver)new OsgiComponentResolver());
            LOG.debug((Object)"Using OsgiLanguageResolver");
            context.setLanguageResolver((LanguageResolver)new OsgiLanguageResolver());
            this.addOsgiAnnotationTypeConverterLoader(context, this.bundleContext);
        } else {
            LOG.warn((Object)"BundleContext not set, cannot run in OSGI container");
        }
        return context;
    }

    protected void updateRegistry(DefaultCamelContext context) {
        ObjectHelper.notNull((Object)this.bundleContext, (String)"BundleContext");
        LOG.debug((Object)"Setting the OSGi ServiceRegistry");
        OsgiServiceRegistry osgiServiceRegistry = new OsgiServiceRegistry(this.bundleContext);
        context.addLifecycleStrategy((LifecycleStrategy)osgiServiceRegistry);
        CompositeRegistry compositeRegistry = new CompositeRegistry();
        compositeRegistry.addRegistry(osgiServiceRegistry);
        compositeRegistry.addRegistry(context.getRegistry());
        context.setRegistry((Registry)compositeRegistry);
    }

    protected void addOsgiAnnotationTypeConverterLoader(DefaultCamelContext context, BundleContext bundleContext) {
        LOG.debug((Object)"Using OsgiAnnotationTypeConverterLoader");
        DefaultTypeConverter typeConverter = (DefaultTypeConverter)context.getTypeConverter();
        List typeConverterLoaders = typeConverter.getTypeConverterLoaders();
        TypeConverterLoader atLoader = null;
        for (TypeConverterLoader loader : typeConverterLoaders) {
            if (!(loader instanceof AnnotationTypeConverterLoader)) continue;
            atLoader = loader;
            break;
        }
        if (atLoader != null) {
            typeConverterLoaders.remove(atLoader);
        }
        typeConverterLoaders.add(new OsgiAnnotationTypeConverterLoader(context.getPackageScanClassResolver()));
    }
}

