/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.builder.ErrorHandlerBuilderRef;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.management.DefaultManagementAgent;
import org.apache.camel.management.DefaultManagementLifecycleStrategy;
import org.apache.camel.management.DefaultManagementStrategy;
import org.apache.camel.management.ManagedManagementStrategy;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.InterceptDefinition;
import org.apache.camel.model.InterceptFromDefinition;
import org.apache.camel.model.InterceptSendToEndpointDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.PackageScanDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteBuilderDefinition;
import org.apache.camel.model.RouteContainer;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.config.PropertiesDefinition;
import org.apache.camel.model.dataformat.DataFormatsDefinition;
import org.apache.camel.processor.interceptor.Delayer;
import org.apache.camel.processor.interceptor.HandleFault;
import org.apache.camel.processor.interceptor.TraceFormatter;
import org.apache.camel.processor.interceptor.Tracer;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.EventFactory;
import org.apache.camel.spi.EventNotifier;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.InflightRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.ManagementAgent;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.PackageScanFilter;
import org.apache.camel.spi.Registry;
import org.apache.camel.spring.CamelBeanPostProcessor;
import org.apache.camel.spring.CamelConsumerTemplateFactoryBean;
import org.apache.camel.spring.CamelEndpointFactoryBean;
import org.apache.camel.spring.CamelJMXAgentDefinition;
import org.apache.camel.spring.CamelProducerTemplateFactoryBean;
import org.apache.camel.spring.CamelProxyFactoryDefinition;
import org.apache.camel.spring.CamelServiceExporterDefinition;
import org.apache.camel.spring.PatternBasedPackageScanFilter;
import org.apache.camel.spring.RouteBuilderFinder;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.EndpointHelper;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="camelContext")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelContextFactoryBean
extends IdentifiedType
implements RouteContainer,
FactoryBean,
InitializingBean,
DisposableBean,
ApplicationContextAware,
ApplicationListener {
    private static final Log LOG = LogFactory.getLog(CamelContextFactoryBean.class);
    @XmlAttribute(required=false)
    private Boolean trace;
    @XmlAttribute(required=false)
    private Boolean streamCache = Boolean.FALSE;
    @XmlAttribute(required=false)
    private Long delayer;
    @XmlAttribute(required=false)
    private Boolean handleFault;
    @XmlAttribute(required=false)
    private String errorHandlerRef;
    @XmlAttribute(required=false)
    private Boolean autoStartup = Boolean.TRUE;
    @XmlElement(name="properties", required=false)
    private PropertiesDefinition properties;
    @XmlElement(name="package", required=false)
    private String[] packages = new String[0];
    @XmlElement(name="packageScan", type=PackageScanDefinition.class, required=false)
    private PackageScanDefinition packageScan;
    @XmlElement(name="jmxAgent", type=CamelJMXAgentDefinition.class, required=false)
    private CamelJMXAgentDefinition camelJMXAgent;
    @XmlElements(value={@XmlElement(name="beanPostProcessor", type=CamelBeanPostProcessor.class, required=false), @XmlElement(name="template", type=CamelProducerTemplateFactoryBean.class, required=false), @XmlElement(name="consumerTemplate", type=CamelConsumerTemplateFactoryBean.class, required=false), @XmlElement(name="proxy", type=CamelProxyFactoryDefinition.class, required=false), @XmlElement(name="export", type=CamelServiceExporterDefinition.class, required=false)})
    private List beans;
    @XmlElement(name="routeBuilder", required=false)
    private List<RouteBuilderDefinition> builderRefs = new ArrayList<RouteBuilderDefinition>();
    @XmlElement(name="endpoint", required=false)
    private List<CamelEndpointFactoryBean> endpoints;
    @XmlElement(name="dataFormats", required=false)
    private DataFormatsDefinition dataFormats;
    @XmlElement(name="onException", required=false)
    private List<OnExceptionDefinition> onExceptions = new ArrayList<OnExceptionDefinition>();
    @XmlElement(name="onCompletion", required=false)
    private List<OnCompletionDefinition> onCompletions = new ArrayList<OnCompletionDefinition>();
    @XmlElement(name="intercept", required=false)
    private List<InterceptDefinition> intercepts = new ArrayList<InterceptDefinition>();
    @XmlElement(name="interceptFrom", required=false)
    private List<InterceptFromDefinition> interceptFroms = new ArrayList<InterceptFromDefinition>();
    @XmlElement(name="interceptSendToEndpoint", required=false)
    private List<InterceptSendToEndpointDefinition> interceptSendToEndpoints = new ArrayList<InterceptSendToEndpointDefinition>();
    @XmlElement(name="route", required=false)
    private List<RouteDefinition> routes = new ArrayList<RouteDefinition>();
    @XmlTransient
    private SpringCamelContext context;
    @XmlTransient
    private List<RoutesBuilder> builders = new ArrayList<RoutesBuilder>();
    @XmlTransient
    private ApplicationContext applicationContext;
    @XmlTransient
    private ClassLoader contextClassLoaderOnStart = Thread.currentThread().getContextClassLoader();
    @XmlTransient
    private BeanPostProcessor beanPostProcessor;

    public Object getObject() throws Exception {
        return this.getContext();
    }

    public Class getObjectType() {
        return SpringCamelContext.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public ClassLoader getContextClassLoaderOnStart() {
        return this.contextClassLoaderOnStart;
    }

    public void afterPropertiesSet() throws Exception {
        Map lifecycleStrategies;
        Map interceptStrategies;
        EventNotifier eventNotifier;
        EventFactory eventFactory;
        ManagementStrategy managementStrategy;
        Delayer delayer;
        HandleFault handleFault;
        Tracer tracer;
        Registry registry;
        FactoryFinderResolver factoryFinderResolver;
        ClassResolver classResolver;
        if (this.properties != null) {
            this.getContext().setProperties(this.properties.asMap());
        }
        this.initJMXAgent();
        PackageScanClassResolver packageResolver = this.getBeanForType(PackageScanClassResolver.class);
        if (packageResolver != null) {
            LOG.info((Object)("Using custom PackageScanClassResolver: " + packageResolver));
            this.getContext().setPackageScanClassResolver(packageResolver);
        }
        if ((classResolver = this.getBeanForType(ClassResolver.class)) != null) {
            LOG.info((Object)("Using custom ClassResolver: " + classResolver));
            this.getContext().setClassResolver(classResolver);
        }
        if ((factoryFinderResolver = this.getBeanForType(FactoryFinderResolver.class)) != null) {
            LOG.info((Object)("Using custom FactoryFinderResolver: " + factoryFinderResolver));
            this.getContext().setFactoryFinderResolver(factoryFinderResolver);
        }
        if ((registry = this.getBeanForType(Registry.class)) != null) {
            LOG.info((Object)("Using custom Registry: " + registry));
            this.getContext().setRegistry(registry);
        }
        if ((tracer = this.getBeanForType(Tracer.class)) != null) {
            TraceFormatter formatter = this.getBeanForType(TraceFormatter.class);
            if (formatter != null) {
                tracer.setFormatter(formatter);
            }
            LOG.info((Object)("Using custom Tracer: " + tracer));
            this.getContext().addInterceptStrategy((InterceptStrategy)tracer);
        }
        if ((handleFault = this.getBeanForType(HandleFault.class)) != null) {
            LOG.info((Object)("Using custom HandleFault: " + handleFault));
            this.getContext().addInterceptStrategy((InterceptStrategy)handleFault);
        }
        if ((delayer = this.getBeanForType(Delayer.class)) != null) {
            LOG.info((Object)("Using custom Delayer: " + delayer));
            this.getContext().addInterceptStrategy((InterceptStrategy)delayer);
        }
        InflightRepository inflightRepository = this.getBeanForType(InflightRepository.class);
        if (delayer != null) {
            LOG.info((Object)("Using custom InflightRepository: " + inflightRepository));
            this.getContext().setInflightRepository(inflightRepository);
        }
        if ((managementStrategy = this.getBeanForType(ManagementStrategy.class)) != null) {
            LOG.info((Object)("Using custom ManagementStrategy: " + managementStrategy));
            this.getContext().setManagementStrategy(managementStrategy);
        }
        if ((eventFactory = this.getBeanForType(EventFactory.class)) != null) {
            LOG.info((Object)("Using custom EventFactory: " + eventFactory));
            this.getContext().getManagementStrategy().setEventFactory(eventFactory);
        }
        if ((eventNotifier = this.getBeanForType(EventNotifier.class)) != null) {
            LOG.info((Object)("Using custom EventNotifier: " + eventNotifier));
            this.getContext().getManagementStrategy().setEventNotifier(eventNotifier);
        }
        if ((interceptStrategies = this.getContext().getRegistry().lookupByType(InterceptStrategy.class)) != null && !interceptStrategies.isEmpty()) {
            for (String id : interceptStrategies.keySet()) {
                InterceptStrategy strategy = (InterceptStrategy)interceptStrategies.get(id);
                if (this.getContext().getInterceptStrategies().contains(strategy)) continue;
                LOG.info((Object)("Using custom intercept strategy with id: " + id + " and implementation: " + strategy));
                this.getContext().addInterceptStrategy(strategy);
            }
        }
        if ((lifecycleStrategies = this.getContext().getRegistry().lookupByType(LifecycleStrategy.class)) != null && !lifecycleStrategies.isEmpty()) {
            for (String id : lifecycleStrategies.keySet()) {
                LifecycleStrategy strategy = (LifecycleStrategy)lifecycleStrategies.get(id);
                if (this.getContext().getLifecycleStrategies().contains(strategy)) continue;
                LOG.info((Object)("Using custom lifecycle strategy with id: " + id + " and implementation: " + strategy));
                this.getContext().addLifecycleStrategy(strategy);
            }
        }
        if (this.beanPostProcessor != null) {
            if (this.beanPostProcessor instanceof ApplicationContextAware) {
                ((ApplicationContextAware)this.beanPostProcessor).setApplicationContext(this.applicationContext);
            }
            if (this.beanPostProcessor instanceof CamelBeanPostProcessor) {
                ((CamelBeanPostProcessor)this.beanPostProcessor).setCamelContext((CamelContext)this.getContext());
            }
        }
        for (RouteDefinition route : this.routes) {
            this.initInterceptors(route);
            this.initOnCompletions(route);
            this.initPolicies(route);
            this.initOnExceptions(route);
            this.initToAsync(route);
            this.initParent(route);
        }
        if (this.dataFormats != null) {
            this.getContext().setDataFormats(this.dataFormats.asMap());
        }
        this.getContext().addRouteDefinitions(this.routes);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found JAXB created routes: " + this.getRoutes()));
        }
        this.findRouteBuilders();
        this.installRoutes();
    }

    private void initParent(RouteDefinition route) {
        for (ProcessorDefinition output : route.getOutputs()) {
            output.setParent((ProcessorDefinition)route);
            if (output.getOutputs() == null) continue;
            this.initParent(output);
        }
    }

    private void initParent(ProcessorDefinition parent) {
        List children = parent.getOutputs();
        for (ProcessorDefinition child : children) {
            child.setParent(parent);
            if (child.getOutputs() == null) continue;
            this.initParent(child);
        }
    }

    private void initToAsync(RouteDefinition route) {
        ArrayList<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
        ToDefinition toAsync = null;
        for (ProcessorDefinition output : route.getOutputs()) {
            ToDefinition to;
            if (toAsync != null) {
                toAsync.getOutputs().add(output);
            } else {
                outputs.add(output);
            }
            if (!(output instanceof ToDefinition) || (to = (ToDefinition)output).isAsync() == null || !to.isAsync().booleanValue()) continue;
            toAsync = to;
        }
        route.clearOutput();
        route.getOutputs().addAll(outputs);
    }

    private void initOnExceptions(RouteDefinition route) {
        ArrayList<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
        ArrayList<ProcessorDefinition> exceptionHandlers = new ArrayList<ProcessorDefinition>();
        if (this.onExceptions != null && !this.onExceptions.isEmpty()) {
            route.getOutputs().addAll(0, this.onExceptions);
        }
        for (ProcessorDefinition output : route.getOutputs()) {
            if (output instanceof OnExceptionDefinition) {
                exceptionHandlers.add(output);
                continue;
            }
            outputs.add(output);
        }
        route.clearOutput();
        route.getOutputs().addAll(exceptionHandlers);
        route.getOutputs().addAll(outputs);
    }

    private void initInterceptors(RouteDefinition route) {
        for (InterceptDefinition interceptDefinition : this.getIntercepts()) {
            interceptDefinition.afterPropertiesSet();
            route.getOutputs().add(0, interceptDefinition);
        }
        for (InterceptFromDefinition interceptFromDefinition : this.getInterceptFroms()) {
            boolean match = true;
            if (interceptFromDefinition.getUri() != null) {
                match = false;
                for (FromDefinition input : route.getInputs()) {
                    if (!EndpointHelper.matchEndpoint((String)input.getUri(), (String)interceptFromDefinition.getUri())) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            interceptFromDefinition.afterPropertiesSet();
            route.getOutputs().add(0, interceptFromDefinition);
        }
        for (InterceptSendToEndpointDefinition interceptSendToEndpointDefinition : this.getInterceptSendToEndpoints()) {
            interceptSendToEndpointDefinition.afterPropertiesSet();
            route.getOutputs().add(0, interceptSendToEndpointDefinition);
        }
    }

    private void initOnCompletions(RouteDefinition route) {
        boolean hasRouteScope = false;
        for (ProcessorDefinition out : route.getOutputs()) {
            if (!(out instanceof OnCompletionDefinition)) continue;
            hasRouteScope = true;
            break;
        }
        if (!hasRouteScope) {
            int index = 0;
            for (int i = 0; i < route.getOutputs().size(); ++i) {
                index = i;
                ProcessorDefinition out = (ProcessorDefinition)route.getOutputs().get(i);
                if (!(out instanceof InterceptDefinition) && !(out instanceof InterceptSendToEndpointDefinition)) break;
            }
            route.getOutputs().addAll(index, this.getOnCompletions());
        }
    }

    private void initPolicies(RouteDefinition route) {
        List types = route.getOutputs();
        PolicyDefinition policy = null;
        TransactedDefinition transacted = null;
        for (ProcessorDefinition type : types) {
            if (type instanceof PolicyDefinition) {
                policy = (PolicyDefinition)type;
                continue;
            }
            if (type instanceof TransactedDefinition) {
                transacted = (TransactedDefinition)type;
                continue;
            }
            if (policy != null) {
                policy.addOutput(type);
                continue;
            }
            if (transacted == null) continue;
            transacted.addOutput(type);
        }
        if (policy != null) {
            route.clearOutput();
            route.addOutput(policy);
        } else if (transacted != null) {
            route.clearOutput();
            route.addOutput(transacted);
        }
    }

    private void initJMXAgent() throws Exception {
        if (this.camelJMXAgent != null && this.camelJMXAgent.isDisabled().booleanValue()) {
            LOG.info((Object)"JMXAgent disabled");
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().setManagementStrategy((ManagementStrategy)new DefaultManagementStrategy());
        } else if (this.camelJMXAgent != null) {
            LOG.info((Object)("JMXAgent enabled: " + (Object)((Object)this.camelJMXAgent)));
            DefaultManagementAgent agent = new DefaultManagementAgent();
            agent.setConnectorPort(this.camelJMXAgent.getConnectorPort());
            agent.setCreateConnector(this.camelJMXAgent.isCreateConnector());
            agent.setMBeanObjectDomainName(this.camelJMXAgent.getMbeanObjectDomainName());
            agent.setMBeanServerDefaultDomain(this.camelJMXAgent.getMbeanServerDefaultDomain());
            agent.setRegistryPort(this.camelJMXAgent.getRegistryPort());
            agent.setServiceUrlPath(this.camelJMXAgent.getServiceUrlPath());
            agent.setUsePlatformMBeanServer(this.camelJMXAgent.isUsePlatformMBeanServer());
            agent.setOnlyRegisterProcessorWithCustomId(this.camelJMXAgent.getOnlyRegisterProcessorWithCustomId());
            ManagedManagementStrategy managementStrategy = new ManagedManagementStrategy((ManagementAgent)agent);
            this.getContext().setManagementStrategy((ManagementStrategy)managementStrategy);
            this.getContext().getLifecycleStrategies().clear();
            this.getContext().addLifecycleStrategy((LifecycleStrategy)new DefaultManagementLifecycleStrategy((CamelContext)this.getContext()));
            this.getContext().getManagementStrategy().onlyManageProcessorWithCustomId(this.camelJMXAgent.getOnlyRegisterProcessorWithCustomId().booleanValue());
            this.getContext().getManagementStrategy().setSatisticsLevel(this.camelJMXAgent.getStatisticsLevel());
        }
    }

    private <T> T getBeanForType(Class<T> clazz) {
        ApplicationContext parentContext;
        Object bean = null;
        String[] names = this.getApplicationContext().getBeanNamesForType(clazz, true, true);
        if (names.length == 1) {
            bean = this.getApplicationContext().getBean(names[0], clazz);
        }
        if (bean == null && (parentContext = this.getApplicationContext().getParent()) != null && (names = parentContext.getBeanNamesForType(clazz, true, true)).length == 1) {
            bean = parentContext.getBean(names[0], clazz);
        }
        return (T)bean;
    }

    public void destroy() throws Exception {
        this.getContext().stop();
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (this.context != null) {
            this.context.onApplicationEvent(event);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Publishing spring-event: " + event));
            }
            if (event instanceof ContextRefreshedEvent) {
                try {
                    LOG.debug((Object)"Starting the context now!");
                    this.getContext().start();
                }
                catch (Exception e) {
                    throw ObjectHelper.wrapRuntimeCamelException((Throwable)e);
                }
            }
        }
    }

    public SpringCamelContext getContext() throws Exception {
        if (this.context == null) {
            this.context = this.createContext();
        }
        return this.context;
    }

    public void setContext(SpringCamelContext context) {
        this.context = context;
    }

    public List<RouteDefinition> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<RouteDefinition> routes) {
        this.routes = routes;
    }

    public List<InterceptDefinition> getIntercepts() {
        return this.intercepts;
    }

    public void setIntercepts(List<InterceptDefinition> intercepts) {
        this.intercepts = intercepts;
    }

    public List<InterceptFromDefinition> getInterceptFroms() {
        return this.interceptFroms;
    }

    public void setInterceptFroms(List<InterceptFromDefinition> interceptFroms) {
        this.interceptFroms = interceptFroms;
    }

    public List<InterceptSendToEndpointDefinition> getInterceptSendToEndpoints() {
        return this.interceptSendToEndpoints;
    }

    public void setInterceptSendToEndpoints(List<InterceptSendToEndpointDefinition> interceptSendToEndpoints) {
        this.interceptSendToEndpoints = interceptSendToEndpoints;
    }

    public ApplicationContext getApplicationContext() {
        if (this.applicationContext == null) {
            throw new IllegalArgumentException("No applicationContext has been injected!");
        }
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public PropertiesDefinition getProperties() {
        return this.properties;
    }

    public void setProperties(PropertiesDefinition properties) {
        this.properties = properties;
    }

    @Deprecated
    public String[] getPackages() {
        return this.packages;
    }

    @Deprecated
    public void setPackages(String[] packages) {
        this.packages = packages;
    }

    public PackageScanDefinition getPackageScan() {
        return this.packageScan;
    }

    public void setPackageScan(PackageScanDefinition packageScan) {
        this.packageScan = packageScan;
    }

    public void setBeanPostProcessor(BeanPostProcessor postProcessor) {
        this.beanPostProcessor = postProcessor;
    }

    public BeanPostProcessor getBeanPostProcessor() {
        return this.beanPostProcessor;
    }

    public void setCamelJMXAgent(CamelJMXAgentDefinition agent) {
        this.camelJMXAgent = agent;
    }

    public Boolean getTrace() {
        return this.trace;
    }

    public void setTrace(Boolean trace) {
        this.trace = trace;
    }

    public Boolean getStreamCache() {
        return this.streamCache;
    }

    public void setStreamCache(Boolean streamCache) {
        this.streamCache = streamCache;
    }

    public Long getDelayer() {
        return this.delayer;
    }

    public void setDelayer(Long delayer) {
        this.delayer = delayer;
    }

    public Boolean getHandleFault() {
        return this.handleFault;
    }

    public void setHandleFault(Boolean handleFault) {
        this.handleFault = handleFault;
    }

    public CamelJMXAgentDefinition getCamelJMXAgent() {
        return this.camelJMXAgent;
    }

    public List<RouteBuilderDefinition> getBuilderRefs() {
        return this.builderRefs;
    }

    public void setBuilderRefs(List<RouteBuilderDefinition> builderRefs) {
        this.builderRefs = builderRefs;
    }

    public String getErrorHandlerRef() {
        return this.errorHandlerRef;
    }

    public void setErrorHandlerRef(String errorHandlerRef) {
        this.errorHandlerRef = errorHandlerRef;
    }

    public void setDataFormats(DataFormatsDefinition dataFormats) {
        this.dataFormats = dataFormats;
    }

    public DataFormatsDefinition getDataFormats() {
        return this.dataFormats;
    }

    public void setOnExceptions(List<OnExceptionDefinition> onExceptions) {
        this.onExceptions = onExceptions;
    }

    public List<OnExceptionDefinition> getOnExceptions() {
        return this.onExceptions;
    }

    public List<OnCompletionDefinition> getOnCompletions() {
        return this.onCompletions;
    }

    public void setOnCompletions(List<OnCompletionDefinition> onCompletions) {
        this.onCompletions = onCompletions;
    }

    public Boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(Boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    protected SpringCamelContext createContext() {
        SpringCamelContext ctx = new SpringCamelContext(this.getApplicationContext());
        ctx.setName(this.getId());
        if (this.streamCache != null) {
            ctx.setStreamCaching(this.streamCache);
        }
        if (this.trace != null) {
            ctx.setTracing(this.trace);
        }
        if (this.delayer != null) {
            ctx.setDelayer(this.delayer);
        }
        if (this.handleFault != null) {
            ctx.setHandleFault(this.handleFault);
        }
        if (this.errorHandlerRef != null) {
            ctx.setErrorHandlerBuilder((ErrorHandlerBuilder)new ErrorHandlerBuilderRef(this.errorHandlerRef));
        }
        if (this.autoStartup != null) {
            ctx.setAutoStartup(this.autoStartup);
        }
        return ctx;
    }

    protected void installRoutes() throws Exception {
        ArrayList<RouteBuilder> builders = new ArrayList<RouteBuilder>();
        if (this.builderRefs != null) {
            for (RouteBuilderDefinition builderRef : this.builderRefs) {
                RouteBuilder builder = builderRef.createRouteBuilder((CamelContext)this.getContext());
                if (builder != null) {
                    builders.add(builder);
                    continue;
                }
                RoutesBuilder routes = builderRef.createRoutes((CamelContext)this.getContext());
                if (routes != null) {
                    this.builders.add(routes);
                    continue;
                }
                throw new CamelException("Cannot find any routes with this RouteBuilder reference: " + builderRef);
            }
        }
        for (RoutesBuilder routeBuilder : this.builders) {
            this.getContext().addRoutes(routeBuilder);
        }
        for (RouteBuilder builder : builders) {
            if (this.beanPostProcessor != null) {
                this.beanPostProcessor.postProcessBeforeInitialization((Object)builder, builder.toString());
            }
            this.getContext().addRoutes((RoutesBuilder)builder);
        }
    }

    protected void findRouteBuilders() throws Exception {
        PackageScanClassResolver resolver = this.getContext().getPackageScanClassResolver();
        this.addPackageElementContentsToScanDefinition();
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (packageScanDef != null && packageScanDef.getPackages().size() > 0) {
            PatternBasedPackageScanFilter filter = new PatternBasedPackageScanFilter();
            filter.addIncludePatterns(packageScanDef.getIncludes());
            filter.addExcludePatterns(packageScanDef.getExcludes());
            resolver.addFilter((PackageScanFilter)filter);
            String[] normalized = this.normalizePackages(packageScanDef.getPackages());
            RouteBuilderFinder finder = new RouteBuilderFinder(this.getContext(), normalized, this.getContextClassLoaderOnStart(), this.getBeanPostProcessor(), this.getContext().getPackageScanClassResolver());
            finder.appendBuilders(this.builders);
        }
    }

    private void addPackageElementContentsToScanDefinition() {
        PackageScanDefinition packageScanDef = this.getPackageScan();
        if (this.getPackages() != null && this.getPackages().length > 0) {
            LOG.warn((Object)"Using a packages element to specify packages to search has been deprecated. Please use a packageScan element instead.");
            if (packageScanDef == null) {
                packageScanDef = new PackageScanDefinition();
                this.setPackageScan(packageScanDef);
            }
            for (String pkg : this.getPackages()) {
                packageScanDef.getPackages().add(pkg);
            }
        }
    }

    private String[] normalizePackages(List<String> unnormalized) {
        ArrayList<String> packages = new ArrayList<String>();
        for (String name : unnormalized) {
            if (!ObjectHelper.isNotEmpty((Object)(name = ObjectHelper.normalizeClassName((String)name)))) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Using package: " + name + " to scan for RouteBuilder classes"));
            }
            packages.add(name);
        }
        return packages.toArray(new String[packages.size()]);
    }
}

