/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.Service;
import org.apache.camel.builder.ErrorHandlerBuilder;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.RouteContext;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsgiServiceRegistry
implements Registry,
LifecycleStrategy {
    private BundleContext bundleContext;
    private Map<String, Object> serviceCacheMap = new ConcurrentHashMap<String, Object>();
    private ConcurrentLinkedQueue<ServiceReference> serviceReferenceQueue = new ConcurrentLinkedQueue();

    public OsgiServiceRegistry(BundleContext bc) {
        this.bundleContext = bc;
    }

    public <T> T lookup(String name, Class<T> type) {
        Object service = this.lookup(name);
        return type.cast(service);
    }

    public Object lookup(String name) {
        ServiceReference sr;
        Object service = this.serviceCacheMap.get(name);
        if (service == null && (sr = this.bundleContext.getServiceReference(name)) != null) {
            this.serviceReferenceQueue.add(sr);
            service = this.bundleContext.getService(sr);
            if (service != null) {
                this.serviceCacheMap.put(name, service);
            }
        }
        return service;
    }

    public <T> Map<String, T> lookupByType(Class<T> type) {
        return Collections.EMPTY_MAP;
    }

    public void onComponentAdd(String name, Component component) {
    }

    public void onComponentRemove(String name, Component component) {
    }

    public void onContextStart(CamelContext context) {
    }

    public void onContextStop(CamelContext context) {
        ServiceReference sr = this.serviceReferenceQueue.poll();
        while (sr != null) {
            this.bundleContext.ungetService(sr);
            sr = this.serviceReferenceQueue.poll();
        }
        this.serviceCacheMap.clear();
    }

    public void onEndpointAdd(Endpoint endpoint) {
    }

    public void onEndpointRemove(Endpoint endpoint) {
    }

    public void onRouteContextCreate(RouteContext routeContext) {
    }

    public void onRoutesAdd(Collection<Route> routes) {
    }

    public void onRoutesRemove(Collection<Route> routes) {
    }

    public void onServiceAdd(CamelContext context, Service service, Route route) {
    }

    public void onServiceRemove(CamelContext context, Service service, Route route) {
    }

    public void onErrorHandlerAdd(RouteContext routeContext, Processor processor, ErrorHandlerBuilder errorHandlerBuilder) {
    }
}

