/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.camel.Component;
import org.apache.camel.TypeConverter;
import org.apache.camel.osgi.tracker.BundleTracker;
import org.apache.camel.osgi.tracker.BundleTrackerCustomizer;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.util.IOHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.springframework.osgi.util.BundleDelegatingClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Activator
implements BundleActivator,
BundleTrackerCustomizer {
    public static final String META_INF_TYPE_CONVERTER = "META-INF/services/org/apache/camel/TypeConverter";
    public static final String META_INF_COMPONENT = "META-INF/services/org/apache/camel/component/";
    public static final String META_INF_LANGUAGE = "META-INF/services/org/apache/camel/language/";
    public static final String META_INF_LANGUAGE_RESOLVER = "META-INF/services/org/apache/camel/language/resolver/";
    private static final transient Log LOG = LogFactory.getLog(Activator.class);
    private static final Map<String, ComponentEntry> COMPONENTS = new ConcurrentHashMap<String, ComponentEntry>();
    private static final Map<URL, TypeConverterEntry> TYPE_CONVERTERS = new ConcurrentHashMap<URL, TypeConverterEntry>();
    private static final Map<String, ComponentEntry> LANGUAGES = new ConcurrentHashMap<String, ComponentEntry>();
    private static final Map<String, ComponentEntry> LANGUAGE_RESOLVERS = new ConcurrentHashMap<String, ComponentEntry>();
    private static Bundle bundle;
    private BundleTracker tracker;

    @Override
    public Object addingBundle(Bundle bundle, BundleEvent event) {
        this.modifiedBundle(bundle, event, null);
        return bundle;
    }

    @Override
    public void modifiedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Bundle started: " + bundle.getSymbolicName()));
        }
        this.mayBeAddComponentAndLanguageFor(bundle);
        this.mayBeAddTypeConverterFor(bundle);
    }

    @Override
    public void removedBundle(Bundle bundle, BundleEvent event, Object object) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Bundle stopped: " + bundle.getSymbolicName()));
        }
        this.mayBeRemoveComponentAndLanguageFor(bundle);
        this.mayBeRemoveTypeConverterFor(bundle);
    }

    protected void addComponentEntry(String entryPath, Bundle bundle, Map<String, ComponentEntry> entries, Class clazz) {
        try {
            if (bundle.loadClass(clazz.getName()) != clazz) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        Enumeration e = bundle.getEntryPaths(entryPath);
        if (e != null) {
            while (e.hasMoreElements()) {
                String path = (String)e.nextElement();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Found entry: " + path + " in bundle " + bundle.getSymbolicName()));
                }
                ComponentEntry entry = new ComponentEntry();
                entry.bundle = bundle;
                entry.path = path;
                entry.name = path.substring(path.lastIndexOf("/") + 1);
                entries.put(entry.name, entry);
            }
        }
    }

    protected void mayBeAddComponentAndLanguageFor(Bundle bundle) {
        this.addComponentEntry(META_INF_COMPONENT, bundle, COMPONENTS, Component.class);
        this.addComponentEntry(META_INF_LANGUAGE, bundle, LANGUAGES, Language.class);
        this.addComponentEntry(META_INF_LANGUAGE_RESOLVER, bundle, LANGUAGE_RESOLVERS, LanguageResolver.class);
    }

    protected void mayBeAddTypeConverterFor(Bundle bundle) {
        try {
            Class<TypeConverter> clazz = TypeConverter.class;
            if (bundle.loadClass(clazz.getName()) != clazz) {
                return;
            }
        }
        catch (Throwable t) {
            return;
        }
        try {
            Enumeration e = bundle.getResources(META_INF_TYPE_CONVERTER);
            if (e != null) {
                while (e.hasMoreElements()) {
                    URL resource = (URL)e.nextElement();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Found entry: " + resource + " in bundle " + bundle.getSymbolicName()));
                    }
                    TypeConverterEntry entry = new TypeConverterEntry();
                    entry.bundle = bundle;
                    entry.resource = resource;
                    entry.converterPackages = this.getConverterPackages(resource);
                    TYPE_CONVERTERS.put(resource, entry);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void mayBeRemoveComponentAndLanguageFor(Bundle bundle) {
        this.removeComponentEntry(bundle, COMPONENTS);
        this.removeComponentEntry(bundle, LANGUAGES);
        this.removeComponentEntry(bundle, LANGUAGE_RESOLVERS);
    }

    protected void removeComponentEntry(Bundle bundle, Map<String, ComponentEntry> entries) {
        ComponentEntry[] entriesArray;
        for (ComponentEntry entry : entriesArray = entries.values().toArray(new ComponentEntry[0])) {
            if (entry.bundle != bundle) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing entry: " + entry.path + " in bundle " + bundle.getSymbolicName()));
            }
            entries.remove(entry.name);
        }
    }

    protected void mayBeRemoveTypeConverterFor(Bundle bundle) {
        TypeConverterEntry[] entriesArray;
        for (TypeConverterEntry entry : entriesArray = TYPE_CONVERTERS.values().toArray(new TypeConverterEntry[0])) {
            if (entry.bundle != bundle) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Removing entry: " + entry.resource + " in bundle " + bundle.getSymbolicName()));
            }
            COMPONENTS.remove(entry.resource);
        }
    }

    public void start(BundleContext context) throws Exception {
        LOG.info((Object)"Camel activator starting");
        bundle = context.getBundle();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Using bundle: " + bundle));
        }
        this.tracker = new BundleTracker(context, 32, this);
        this.tracker.open();
        LOG.info((Object)"Camel activator started");
    }

    public void stop(BundleContext context) throws Exception {
        LOG.info((Object)"Camel activator stopping");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Removing Camel bundles");
        }
        this.tracker.close();
        LOG.info((Object)"Camel activator stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Set<String> getConverterPackages(URL resource) {
        HashSet<String> packages = new HashSet<String>();
        if (resource == null) return packages;
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(resource.openStream()));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).startsWith("#") || line.length() == 0) continue;
                this.tokenize(packages, line);
            }
            if (reader == null) return packages;
        }
        catch (Exception ignore) {
            if (reader == null) return packages;
            IOHelper.close((Closeable)reader, null, (Log)LOG);
            return packages;
            catch (Throwable throwable) {
                if (reader == null) throw throwable;
                IOHelper.close(reader, null, (Log)LOG);
                throw throwable;
            }
        }
        IOHelper.close((Closeable)reader, null, (Log)LOG);
        return packages;
    }

    protected void tokenize(Set<String> packages, String line) {
        StringTokenizer iter = new StringTokenizer(line, ",");
        while (iter.hasMoreTokens()) {
            String name = iter.nextToken().trim();
            if (name.length() <= 0) continue;
            packages.add(name);
        }
    }

    protected static Bundle getBundle() {
        return bundle;
    }

    protected static TypeConverterEntry[] getTypeConverterEntries() {
        Collection<TypeConverterEntry> entries = TYPE_CONVERTERS.values();
        return entries.toArray(new TypeConverterEntry[entries.size()]);
    }

    public static Class getComponent(String name) throws Exception {
        LOG.trace((Object)("Finding Component: " + name));
        return Activator.getClassFromEntries(name, COMPONENTS);
    }

    public static Class getLanguage(String name) throws Exception {
        LOG.trace((Object)("Finding Language: " + name));
        return Activator.getClassFromEntries(name, LANGUAGES);
    }

    public static Class getLanguageResolver(String name) throws Exception {
        LOG.trace((Object)("Finding LanguageResolver: " + name));
        return Activator.getClassFromEntries(name, LANGUAGE_RESOLVERS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Class getClassFromEntries(String name, Map<String, ComponentEntry> entries) throws Exception {
        ComponentEntry entry = entries.get(name);
        if (entry == null) {
            return null;
        }
        if (entry.type == null) {
            URL url = entry.bundle.getEntry(entry.path);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("The entry " + name + "'s url is" + url));
            }
            Properties properties = new Properties();
            BufferedInputStream reader = null;
            try {
                reader = new BufferedInputStream(url.openStream());
                properties.load(reader);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (Exception ignore) {}
            }
            String classname = (String)properties.get("class");
            BundleDelegatingClassLoader loader = BundleDelegatingClassLoader.createBundleClassLoaderFor((Bundle)entry.bundle);
            entry.type = loader.loadClass(classname);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found entry: " + name + " via type: " + entry.type.getName()));
        }
        return entry.type;
    }

    public class TypeConverterEntry {
        Bundle bundle;
        URL resource;
        Set<String> converterPackages;
    }

    private class ComponentEntry {
        Bundle bundle;
        String path;
        String name;
        Class type;

        private ComponentEntry() {
        }
    }
}

