/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.osgi;

import java.util.List;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.impl.converter.AnnotationTypeConverterLoader;
import org.apache.camel.impl.converter.DefaultTypeConverter;
import org.apache.camel.impl.converter.TypeConverterLoader;
import org.apache.camel.osgi.CompositeRegistry;
import org.apache.camel.osgi.OsgiAnnotationTypeConverterLoader;
import org.apache.camel.osgi.OsgiClassResolver;
import org.apache.camel.osgi.OsgiComponentResolver;
import org.apache.camel.osgi.OsgiFactoryFinderResolver;
import org.apache.camel.osgi.OsgiLanguageResolver;
import org.apache.camel.osgi.OsgiPackageScanClassResolver;
import org.apache.camel.osgi.OsgiServiceRegistry;
import org.apache.camel.spi.ClassResolver;
import org.apache.camel.spi.ComponentResolver;
import org.apache.camel.spi.FactoryFinderResolver;
import org.apache.camel.spi.LanguageResolver;
import org.apache.camel.spi.LifecycleStrategy;
import org.apache.camel.spi.PackageScanClassResolver;
import org.apache.camel.spi.Registry;
import org.apache.camel.spi.TypeConverterRegistry;
import org.apache.camel.util.ObjectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;

public final class OsgiCamelContextHelper {
    private static final transient Log LOG = LogFactory.getLog(OsgiCamelContextHelper.class);

    private OsgiCamelContextHelper() {
    }

    public static DefaultTypeConverter createTypeConverter(DefaultCamelContext context) {
        DefaultTypeConverter answer = new DefaultTypeConverter(context.getPackageScanClassResolver(), context.getInjector(), context.getDefaultFactoryFinder());
        List typeConverterLoaders = answer.getTypeConverterLoaders();
        TypeConverterLoader atLoader = null;
        for (TypeConverterLoader loader : typeConverterLoaders) {
            if (!(loader instanceof AnnotationTypeConverterLoader)) continue;
            atLoader = loader;
            break;
        }
        if (atLoader != null) {
            typeConverterLoaders.remove(atLoader);
        }
        typeConverterLoaders.add(new OsgiAnnotationTypeConverterLoader(context.getPackageScanClassResolver()));
        context.setTypeConverterRegistry((TypeConverterRegistry)answer);
        return answer;
    }

    public static void osgiUpdate(DefaultCamelContext camelContext, BundleContext bundleContext) {
        if (bundleContext != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Using OSGi resolvers");
            }
            OsgiCamelContextHelper.updateRegistry(camelContext, bundleContext);
            LOG.debug((Object)"Using the OsgiClassResolver");
            camelContext.setClassResolver((ClassResolver)new OsgiClassResolver(bundleContext));
            LOG.debug((Object)"Using OsgiFactoryFinderResolver");
            camelContext.setFactoryFinderResolver((FactoryFinderResolver)new OsgiFactoryFinderResolver());
            LOG.debug((Object)"Using OsgiPackageScanClassResolver");
            camelContext.setPackageScanClassResolver((PackageScanClassResolver)new OsgiPackageScanClassResolver(bundleContext));
            LOG.debug((Object)"Using OsgiComponentResolver");
            camelContext.setComponentResolver((ComponentResolver)new OsgiComponentResolver());
            LOG.debug((Object)"Using OsgiLanguageResolver");
            camelContext.setLanguageResolver((LanguageResolver)new OsgiLanguageResolver());
        } else {
            LOG.warn((Object)"BundleContext not set, cannot run in OSGI container");
        }
    }

    public static void updateRegistry(DefaultCamelContext camelContext, BundleContext bundleContext) {
        ObjectHelper.notNull((Object)bundleContext, (String)"BundleContext");
        LOG.debug((Object)"Setting the OSGi ServiceRegistry");
        OsgiServiceRegistry osgiServiceRegistry = new OsgiServiceRegistry(bundleContext);
        camelContext.addLifecycleStrategy((LifecycleStrategy)osgiServiceRegistry);
        CompositeRegistry compositeRegistry = new CompositeRegistry();
        compositeRegistry.addRegistry(osgiServiceRegistry);
        compositeRegistry.addRegistry(camelContext.getRegistry());
        camelContext.setRegistry((Registry)compositeRegistry);
    }
}

