/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.security;

import java.util.List;
import javax.security.auth.Subject;
import org.apache.camel.CamelAuthorizationException;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.security.AuthenticationAdapter;
import org.apache.camel.component.spring.security.DefaultAuthenticationAdapter;
import org.apache.camel.component.spring.security.SpringSecurityAccessPolicy;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.processor.DelegateProcessor;
import org.apache.camel.spi.AuthorizationPolicy;
import org.apache.camel.spi.RouteContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.event.AuthorizationFailureEvent;
import org.springframework.security.access.event.AuthorizedEvent;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.Assert;

public class SpringSecurityAuthorizationPolicy
extends IdentifiedType
implements AuthorizationPolicy,
InitializingBean,
ApplicationEventPublisherAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(SpringSecurityAuthorizationPolicy.class);
    private AccessDecisionManager accessDecisionManager;
    private AuthenticationManager authenticationManager;
    private AuthenticationAdapter authenticationAdapter;
    private ApplicationEventPublisher eventPublisher;
    private SpringSecurityAccessPolicy accessPolicy;
    private boolean alwaysReauthenticate;
    private boolean useThreadSecurityContext = true;

    public void beforeWrap(RouteContext routeContext, ProcessorDefinition<?> definition) {
    }

    public Processor wrap(RouteContext routeContext, Processor processor) {
        return new AuthorizeDelegateProcess(processor);
    }

    protected void beforeProcess(Exchange exchange) throws Exception {
        List<ConfigAttribute> attributes = this.accessPolicy.getConfigAttributes();
        try {
            Authentication authToken = this.getAuthentication(exchange.getIn());
            if (authToken == null) {
                CamelAuthorizationException authorizationException = new CamelAuthorizationException("Cannot find the Authentication instance.", exchange);
                throw authorizationException;
            }
            Authentication authenticated = this.authenticateIfRequired(authToken);
            try {
                this.accessDecisionManager.decide(authenticated, (Object)exchange, attributes);
            }
            catch (AccessDeniedException accessDeniedException) {
                exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)this.getId());
                AuthorizationFailureEvent event = new AuthorizationFailureEvent((Object)exchange, attributes, authenticated, accessDeniedException);
                this.publishEvent((ApplicationEvent)event);
                throw accessDeniedException;
            }
            this.publishEvent((ApplicationEvent)new AuthorizedEvent((Object)exchange, attributes, authenticated));
        }
        catch (RuntimeException exception) {
            exchange.getIn().setHeader("CamelAuthenticationFailurePolicyId", (Object)this.getId());
            CamelAuthorizationException authorizationException = new CamelAuthorizationException("Cannot access the processor which has been protected.", exchange, (Throwable)exception);
            throw authorizationException;
        }
    }

    protected Authentication getAuthentication(Message message) {
        Subject subject = (Subject)message.getHeader("CamelAuthentication", Subject.class);
        Authentication answer = null;
        if (subject != null) {
            answer = this.getAuthenticationAdapter().toAuthentication(subject);
        }
        if (answer == null && this.useThreadSecurityContext) {
            answer = SecurityContextHolder.getContext().getAuthentication();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Get the authentication from SecurityContextHolder");
            }
        }
        return answer;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.authenticationManager, (String)"An AuthenticationManager is required");
        Assert.notNull((Object)this.accessDecisionManager, (String)"An AccessDecisionManager is required");
        Assert.notNull((Object)this.accessPolicy, (String)"The accessPolicy is required");
    }

    private Authentication authenticateIfRequired(Authentication authentication) {
        if (authentication.isAuthenticated() && !this.alwaysReauthenticate) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Previously Authenticated: " + authentication);
            }
            return authentication;
        }
        authentication = this.authenticationManager.authenticate(authentication);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Successfully Authenticated: " + authentication);
        }
        return authentication;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.eventPublisher != null) {
            this.eventPublisher.publishEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthenticationAdapter getAuthenticationAdapter() {
        if (this.authenticationAdapter == null) {
            SpringSecurityAuthorizationPolicy springSecurityAuthorizationPolicy = this;
            synchronized (springSecurityAuthorizationPolicy) {
                if (this.authenticationAdapter != null) {
                    return this.authenticationAdapter;
                }
                this.authenticationAdapter = new DefaultAuthenticationAdapter();
            }
        }
        return this.authenticationAdapter;
    }

    public void setAuthenticationAdapter(AuthenticationAdapter adapter) {
        this.authenticationAdapter = adapter;
    }

    public AccessDecisionManager getAccessDecisionManager() {
        return this.accessDecisionManager;
    }

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.eventPublisher = applicationEventPublisher;
    }

    public void setSpringSecurityAccessPolicy(SpringSecurityAccessPolicy policy) {
        this.accessPolicy = policy;
    }

    public SpringSecurityAccessPolicy getSpringSecurityAccessPolicy() {
        return this.accessPolicy;
    }

    public boolean isAlwaysReauthenticate() {
        return this.alwaysReauthenticate;
    }

    public void setAlwaysReauthenticate(boolean alwaysReauthenticate) {
        this.alwaysReauthenticate = alwaysReauthenticate;
    }

    public boolean isUseThreadSecurityContext() {
        return this.useThreadSecurityContext;
    }

    public void setUseThreadSecurityContext(boolean useThreadSecurityContext) {
        this.useThreadSecurityContext = useThreadSecurityContext;
    }

    public void setAuthenticationManager(AuthenticationManager newManager) {
        this.authenticationManager = newManager;
    }

    public void setAccessDecisionManager(AccessDecisionManager accessDecisionManager) {
        this.accessDecisionManager = accessDecisionManager;
    }

    private class AuthorizeDelegateProcess
    extends DelegateProcessor {
        AuthorizeDelegateProcess(Processor processor) {
            super(processor);
        }

        public void process(Exchange exchange) throws Exception {
            SpringSecurityAuthorizationPolicy.this.beforeProcess(exchange);
            this.processNext(exchange);
        }
    }
}

