/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.ws;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.ws.SpringWebserviceConfiguration;
import org.apache.camel.component.spring.ws.SpringWebserviceEndpoint;
import org.apache.camel.component.spring.ws.SpringWebserviceMessage;
import org.apache.camel.converter.jaxp.XmlConverter;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultExchange;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringWebserviceConsumer
extends DefaultConsumer
implements MessageEndpoint {
    private SpringWebserviceEndpoint endpoint;
    private SpringWebserviceConfiguration configuration;

    public SpringWebserviceConsumer(Endpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = (SpringWebserviceEndpoint)endpoint;
        this.configuration = this.endpoint.getConfiguration();
    }

    public void invoke(MessageContext messageContext) throws Exception {
        Message responseMessage;
        DefaultExchange exchange = new DefaultExchange(this.endpoint.getCamelContext(), ExchangePattern.InOptionalOut);
        this.populateExchangeFromMessageContext(messageContext, (Exchange)exchange);
        this.getProcessor().process((Exchange)exchange);
        if (exchange.getPattern().isOutCapable() && (responseMessage = (Message)exchange.getOut(Message.class)) != null) {
            Source responseBody = (Source)responseMessage.getBody(Source.class);
            WebServiceMessage response = messageContext.getResponse();
            XmlConverter xmlConverter = this.configuration.getXmlConverter();
            xmlConverter.toResult(responseBody, response.getPayloadResult());
        }
    }

    private void populateExchangeFromMessageContext(MessageContext messageContext, Exchange exchange) {
        this.populateExchangeWithPropertiesFromMessageContext(messageContext, exchange);
        WebServiceMessage request = messageContext.getRequest();
        SpringWebserviceMessage inMessage = new SpringWebserviceMessage(request);
        inMessage.setHeaders(this.extractSoapHeadersFromWebServiceMessage(request));
        exchange.setIn((Message)inMessage);
    }

    private void populateExchangeWithPropertiesFromMessageContext(MessageContext messageContext, Exchange exchange) {
        String[] propertyNames = messageContext.getPropertyNames();
        if (propertyNames != null) {
            for (String propertyName : propertyNames) {
                exchange.setProperty(propertyName, messageContext.getProperty(propertyName));
            }
        }
    }

    private Map<String, Object> extractSoapHeadersFromWebServiceMessage(WebServiceMessage request) {
        SoapMessage soapMessage;
        SoapHeader soapHeader;
        HashMap<String, Object> headers = new HashMap<String, Object>();
        if (request instanceof SoapMessage && (soapHeader = (soapMessage = (SoapMessage)request).getSoapHeader()) != null) {
            Iterator attibutesIterator = soapHeader.getAllAttributes();
            while (attibutesIterator.hasNext()) {
                QName name = (QName)attibutesIterator.next();
                headers.put(name.toString(), soapHeader.getAttributeValue(name));
            }
            Iterator elementIter = soapHeader.examineAllHeaderElements();
            while (elementIter.hasNext()) {
                Object element = elementIter.next();
                if (!(element instanceof SoapHeaderElement)) continue;
                QName name = ((SoapHeaderElement)element).getName();
                headers.put(name.toString(), element);
            }
        }
        return headers;
    }

    protected void doStop() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().removeConsumer(this.configuration.getEndpointMappingKey());
        }
        super.doStop();
    }

    protected void doStart() throws Exception {
        if (this.configuration.getEndpointMapping() != null) {
            this.configuration.getEndpointMapping().addConsumer(this.configuration.getEndpointMappingKey(), this);
        }
        super.doStart();
    }
}

