/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.model.IdentifiedType;
import org.apache.camel.spring.util.CamelContextResolverHelper;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

@XmlRootElement(name="endpoint")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CamelEndpointFactoryBean
extends IdentifiedType
implements FactoryBean,
CamelContextAware,
ApplicationContextAware {
    @XmlAttribute
    private Boolean singleton = Boolean.FALSE;
    @XmlAttribute
    private String uri;
    @XmlAttribute
    private String camelContextId;
    @XmlTransient
    private CamelContext context;
    @XmlTransient
    private Endpoint endpoint;
    @XmlTransient
    private ApplicationContext applicationContext;

    public Object getObject() throws Exception {
        if (this.endpoint == null) {
            this.endpoint = this.createEndpoint();
        }
        return this.endpoint;
    }

    public Class getObjectType() {
        return Endpoint.class;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(boolean singleton) {
        this.singleton = singleton;
    }

    public CamelContext getCamelContext() {
        return this.context;
    }

    public void setCamelContext(CamelContext context) {
        this.context = context;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    protected Endpoint createEndpoint() {
        if (this.context == null && this.camelContextId != null) {
            this.context = CamelContextResolverHelper.getCamelContextWithId(this.applicationContext, this.camelContextId);
        }
        ObjectHelper.notNull((Object)this.context, (String)"context");
        ObjectHelper.notNull((Object)this.uri, (String)"uri");
        Endpoint endpoint = this.context.getEndpoint(this.uri);
        if (endpoint == null) {
            throw new NoSuchEndpointException(this.uri);
        }
        return endpoint;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setCamelContextId(String camelContextId) {
        this.camelContextId = camelContextId;
    }
}

