/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BeanBindingTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/component/bean/beanBindingTest.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    public void testBeanBindingUsingBeanExpression() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        result.expectedBodiesReceived(new Object[]{"Bye Claus", "Bye James"});
        ((ValueBuilder)result.message(0).header("count")).isEqualTo((Object)1);
        ((ValueBuilder)result.message(1).header("count")).isEqualTo((Object)2);
        this.template.sendBody("direct:startBeanExpression", (Object)"Claus");
        this.template.sendBody("direct:startBeanExpression", (Object)"James");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanBindingUsingConstantExpression() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        result.expectedBodiesReceived(new Object[]{"Bye Claus", "Bye James"});
        ((ValueBuilder)result.message(0).header("count")).isEqualTo((Object)5);
        ((ValueBuilder)result.message(1).header("count")).isEqualTo((Object)5);
        this.template.sendBody("direct:startConstantExpression", (Object)"Claus");
        this.template.sendBody("direct:startConstantExpression", (Object)"James");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanBindingUsingHeaderExpression() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        result.expectedBodiesReceived(new Object[]{"Bye Claus", "Bye James"});
        ((ValueBuilder)result.message(0).header("count")).isEqualTo((Object)1);
        ((ValueBuilder)result.message(1).header("count")).isEqualTo((Object)2);
        this.template.sendBodyAndHeader("direct:startHeaderExpression", (Object)"Claus", "number", (Object)"1");
        this.template.sendBodyAndHeader("direct:startHeaderExpression", (Object)"James", "number", (Object)"2");
        this.assertMockEndpointsSatisfied();
    }

    public void testBeanBindingUsingManyExpression() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedMessageCount(2);
        result.expectedBodiesReceived(new Object[]{"Bye Claus", "Bye James"});
        ((ValueBuilder)result.message(0).header("count")).isEqualTo((Object)15);
        ((ValueBuilder)result.message(1).header("count")).isEqualTo((Object)20);
        this.template.sendBodyAndHeader("direct:startMany", (Object)"Claus", "number", (Object)"3");
        this.template.sendBodyAndHeader("direct:startMany", (Object)"James", "number", (Object)"4");
        this.assertMockEndpointsSatisfied();
    }
}

