/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BeanRouteTest
extends SpringTestSupport {
    protected Object body = "James";

    public void testSayHello() throws Exception {
        Object value = this.template.requestBody("bean:myBean?method=sayHello", this.body);
        BeanRouteTest.assertEquals((String)"Returned value", (Object)"Hello James!", (Object)value);
    }

    public void testSayGoodbye() throws Exception {
        Object value = this.template.requestBody("bean:myBean?method=sayGoodbye", this.body);
        BeanRouteTest.assertEquals((String)"Returned value", (Object)"Bye James!", (Object)value);
    }

    public void testChooseMethodUsingBodyType() throws Exception {
        Object value = this.template.requestBody("bean:myBean", (Object)4);
        BeanRouteTest.assertEquals((String)"Returned value", (Object)8L, (Object)value);
    }

    public void testAmbiguousMethodCallFails() throws Exception {
        try {
            Object value = this.template.requestBody("bean:myBean", this.body);
            BeanRouteTest.fail((String)("We should have failed to invoke an ambiguous method but instead got: " + value));
        }
        catch (Exception e) {
            this.log.info("Caught expected failure: " + e, (Throwable)e);
        }
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/component/bean/camelContext.xml");
    }
}

