/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.bean;

import org.apache.camel.Consume;
import org.apache.camel.Header;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.language.Bean;
import org.apache.camel.language.Constant;

public class MyBeanBindingConsumer {
    private ProducerTemplate template;

    @Consume(uri="direct:startBeanExpression")
    public void doSomethingBeanExpression(String payload, @Bean(ref="myCounter") int count) {
        this.template.sendBodyAndHeader("mock:result", (Object)("Bye " + payload), "count", (Object)count);
    }

    @Consume(uri="direct:startConstantExpression")
    public void doSomethingConstantExpression(String payload, @Constant(value="5") int count) {
        this.template.sendBodyAndHeader("mock:result", (Object)("Bye " + payload), "count", (Object)count);
    }

    @Consume(uri="direct:startHeaderExpression")
    public void doSomethingHeaderExpression(String payload, @Header(value="number") int count) {
        this.template.sendBodyAndHeader("mock:result", (Object)("Bye " + payload), "count", (Object)count);
    }

    @Consume(uri="direct:startMany")
    public void doSomethingManyExpression(String payload, @Constant(value="5") int count, @Header(value="number") int number) {
        this.template.sendBodyAndHeader("mock:result", (Object)("Bye " + payload), "count", (Object)(count * number));
    }

    public void setTemplate(ProducerTemplate template) {
        this.template = template;
    }
}

