/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.event;

import org.apache.camel.Exchange;
import org.apache.camel.component.event.CamelEvent;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EventRouteTest
extends SpringTestSupport {
    protected Object expectedBody = "Hello there!";
    protected String uri = "spring-event:default";

    public void testSendingCamelExchangeToEndpointResultsInValidApplicationEventAfterTheRefreshEvent() throws Exception {
        MockEndpoint result = (MockEndpoint)this.resolveMandatoryEndpoint("mock:result", MockEndpoint.class);
        result.expectedMessageCount(2);
        this.template.sendBodyAndHeader(this.uri, this.expectedBody, "cheese", (Object)123);
        result.assertIsSatisfied();
        Exchange exchange = (Exchange)result.getReceivedExchanges().get(0);
        Object body = exchange.getIn().getBody(ContextRefreshedEvent.class);
        this.log.info("Received body: " + body);
        EventRouteTest.assertNotNull((Object)body);
        exchange = (Exchange)result.getReceivedExchanges().get(1);
        body = exchange.getIn().getBody();
        this.log.info("Received body: " + body);
        CamelEvent event = (CamelEvent)EventRouteTest.assertIsInstanceOf(CamelEvent.class, (Object)body);
        Object actualBody = event.getExchange().getIn().getBody();
        EventRouteTest.assertEquals((String)"Received event body", (Object)this.expectedBody, (Object)actualBody);
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/component/event/camelContext.xml");
    }
}

