/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.validator;

import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ValidatorRouteTest
extends SpringTestSupport {
    protected MockEndpoint validEndpoint;
    protected MockEndpoint finallyEndpoint;
    protected MockEndpoint invalidEndpoint;

    public void testValidMessage() throws Exception {
        this.validEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><subject>Hey</subject><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    public void testInvalidMessage() throws Exception {
        this.invalidEndpoint.expectedMessageCount(1);
        this.finallyEndpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail xmlns='http://foo.com/bar'><body>Hello world!</body></mail>");
        MockEndpoint.assertIsSatisfied((MockEndpoint[])new MockEndpoint[]{this.validEndpoint, this.invalidEndpoint, this.finallyEndpoint});
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.validEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:valid", MockEndpoint.class);
        this.invalidEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:invalid", MockEndpoint.class);
        this.finallyEndpoint = (MockEndpoint)this.resolveMandatoryEndpoint("mock:finally", MockEndpoint.class);
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/component/validator/camelContext.xml");
    }
}

