/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;

public class XsltContentCacheTest
extends ContextTestSupport {
    private static final String ORIGINAL_XSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"/\"><goodbye><xsl:value-of select=\"/hello\"/></goodbye></xsl:template></xsl:stylesheet>";
    private static final String NEW_XSL = "<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"><xsl:template match=\"/\"><goodnight><xsl:value-of select=\"/hello\"/></goodnight></xsl:template></xsl:stylesheet>";

    public void setUp() throws Exception {
        super.setUp();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)ORIGINAL_XSL, "CamelFileName", (Object)"hello.xsl");
        super.startCamelContext();
    }

    protected void startCamelContext() throws Exception {
    }

    public void testNotCached() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:a", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodnight>world!</goodnight>"});
        this.template.sendBody("direct:a", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }

    public void testCached() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:b", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }

    public void testCachedIsDefault() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:c", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
        this.template.sendBodyAndHeader("file://target/test-classes/org/apache/camel/component/xslt?fileExist=Override", (Object)NEW_XSL, "CamelFileName", (Object)"hello.xsl");
        mock.reset();
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        this.template.sendBody("direct:c", (Object)"<hello>world!</hello>");
        mock.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("direct:a").to("xslt://org/apache/camel/component/xslt/hello.xsl?output=string&contentCache=false")).to("mock:result");
                ((RouteDefinition)this.from("direct:b").to("xslt://org/apache/camel/component/xslt/hello.xsl?output=string&contentCache=true")).to("mock:result");
                ((RouteDefinition)this.from("direct:c").to("xslt://org/apache/camel/component/xslt/hello.xsl?output=string")).to("mock:result");
            }
        };
    }
}

