/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.FileNotFoundException;
import javax.xml.transform.TransformerConfigurationException;
import org.apache.camel.FailedToCreateRouteException;
import org.apache.camel.ResolveEndpointFailedException;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.TestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.impl.DefaultCamelContext;

public class XsltFileNotFoundTest
extends TestSupport {
    public void testNoXsltFile() throws Exception {
        try {
            RouteBuilder builder = this.createRouteBuilder();
            DefaultCamelContext context = new DefaultCamelContext();
            context.addRoutes((RoutesBuilder)builder);
            context.start();
            XsltFileNotFoundTest.fail((String)"Should have thrown an exception due XSLT file not found");
        }
        catch (FailedToCreateRouteException e) {
            XsltFileNotFoundTest.assertIsInstanceOf(ResolveEndpointFailedException.class, (Object)e.getCause());
            XsltFileNotFoundTest.assertIsInstanceOf(TransformerConfigurationException.class, (Object)e.getCause().getCause());
            XsltFileNotFoundTest.assertIsInstanceOf(FileNotFoundException.class, (Object)e.getCause().getCause().getCause());
        }
    }

    protected RouteBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                this.from("seda:a").to("xslt:org/apache/camel/component/xslt/notfound.xsl");
            }
        };
    }
}

