/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.io.File;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.NoSuchHeaderException;
import org.apache.camel.builder.ValueBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.processor.SpringTestHelper;

public class XsltOutputFileTest
extends ContextTestSupport {
    protected CamelContext createCamelContext() throws Exception {
        return SpringTestHelper.createSpringCamelContext(this, "org/apache/camel/component/xslt/XsltOutputFileTest.xml");
    }

    public void testXsltOutput() throws Exception {
        XsltOutputFileTest.createDirectory((String)"target/xslt");
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"<?xml version=\"1.0\" encoding=\"UTF-8\"?><goodbye>world!</goodbye>"});
        mock.expectedFileExists("target/xslt/xsltme.xml");
        ((ValueBuilder)mock.message(0).body()).isInstanceOf(File.class);
        this.template.sendBodyAndHeader("direct:start", (Object)"<hello>world!</hello>", "CamelXsltFileName", (Object)"target/xslt/xsltme.xml");
        this.assertMockEndpointsSatisfied();
    }

    public void testXsltOutputFileMissingHeader() throws Exception {
        try {
            this.template.sendBody("direct:start", (Object)"<hello>world!</hello>");
            XsltOutputFileTest.fail((String)"Should thrown exception");
        }
        catch (CamelExecutionException e) {
            NoSuchHeaderException nshe = (NoSuchHeaderException)XsltOutputFileTest.assertIsInstanceOf(NoSuchHeaderException.class, (Object)e.getCause());
            XsltOutputFileTest.assertEquals((String)"CamelXsltFileName", (String)nshe.getHeaderName());
        }
    }
}

