/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.xslt;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.xslt.TestBean;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class XsltRouteTest
extends SpringTestSupport {
    public void testSendMessageAndHaveItTransformed() throws Exception {
        MockEndpoint endpoint = this.getMockEndpoint("mock:result");
        endpoint.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<mail><subject>Hey</subject><body>Hello world!</body></mail>");
        this.assertMockEndpointsSatisfied();
        List list = endpoint.getReceivedExchanges();
        Exchange exchange = (Exchange)list.get(0);
        String xml = (String)exchange.getIn().getBody(String.class);
        XsltRouteTest.assertNotNull((String)"The transformed XML should not be null", (Object)xml);
        XsltRouteTest.assertTrue((xml.indexOf("transformed") > -1 ? 1 : 0) != 0);
        XsltRouteTest.assertTrue((xml.indexOf("cheese") > -1 ? 1 : 0) != 0);
        XsltRouteTest.assertTrue((xml.indexOf("<subject>Hey</subject>") > -1 ? 1 : 0) != 0);
        XsltRouteTest.assertTrue((xml.indexOf("<body>Hello world!</body>") > -1 ? 1 : 0) != 0);
        TestBean bean = this.getMandatoryBean(TestBean.class, "testBean");
        XsltRouteTest.assertEquals((String)"bean.subject", (String)"Hey", (String)bean.getSubject());
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/component/xslt/camelContext.xml");
    }
}

