/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.spel;

import org.apache.camel.LanguageTestSupport;

public class SpelTest
extends LanguageTestSupport {
    public void testSpelExpressions() throws Exception {
        this.assertExpression("#{exchange}", this.exchange);
        this.assertExpression("#{exchange.getIn().body}", "<hello id='m123'>world!</hello>");
        this.assertExpression("#{getRequest().body}", "<hello id='m123'>world!</hello>");
        this.assertExpression("#{request.body}", "<hello id='m123'>world!</hello>");
        this.assertExpression("#{request.Headers['foo']}", "abc");
        this.assertExpression("#{getRequest().Headers['foo']}", "abc");
        this.assertExpression("#{request.Headers['foo'] == 'abc'}", true);
        this.assertExpression("#{request.headers['bar'] == 123}", true);
        this.assertExpression("#{request.headers['bar'] > 10}", true);
        this.assertExpression("#{6 / -3}", -2);
    }

    public void testSpelPredicates() throws Exception {
        this.assertPredicate("#{request.headers['foo'].startsWith('a')}");
        this.assertPredicate("#{request.headers['foo'] == 'abc'}");
        this.assertPredicateFails("#{request.headers['foo'] == 'badString'}");
    }

    public void testGetOutFalseKeepsNullOutMessage() throws Exception {
        this.assertExpression("exchange.hasOut()", false);
        SpelTest.assertFalse((boolean)this.exchange.hasOut());
    }

    public void testResponseCreatesOutMessage() throws Exception {
        this.assertExpression("#{response.body}", null);
        SpelTest.assertTrue((boolean)this.exchange.hasOut());
    }

    protected String getLanguageName() {
        return "spel";
    }
}

