/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import junit.framework.TestCase;
import org.apache.camel.util.ObjectHelper;
import org.springframework.context.support.AbstractXmlApplicationContext;

public abstract class ApplicationContextTestSupport
extends TestCase {
    protected AbstractXmlApplicationContext applicationContext;

    protected abstract AbstractXmlApplicationContext createApplicationContext();

    protected void setUp() throws Exception {
        this.applicationContext = this.createApplicationContext();
        ApplicationContextTestSupport.assertNotNull((String)"Should have created a valid spring context", (Object)this.applicationContext);
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }

    public <T> T getMandatoryBean(Class<T> type, String name) {
        Object value = this.applicationContext.getBean(name);
        ApplicationContextTestSupport.assertNotNull((String)("No spring bean found for name <" + name + ">"), (Object)value);
        if (type.isInstance(value)) {
            return type.cast(value);
        }
        ApplicationContextTestSupport.fail((String)("Spring bean <" + name + "> is not an instanceof " + type.getName() + " but is of type " + ObjectHelper.className((Object)value)));
        return null;
    }
}

