/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.Map;
import org.apache.camel.impl.DefaultConsumerTemplate;
import org.apache.camel.impl.DefaultProducerTemplate;
import org.apache.camel.spring.CamelContextAwareBean;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CamelContextAwareTest
extends SpringTestSupport {
    protected CamelContextAwareBean bean1;

    public void testInjectionPoints() throws Exception {
        CamelContextAwareTest.assertNotNull((String)"No CamelContext injected!", (Object)this.bean1.getCamelContext());
        Map properties = this.bean1.getCamelContext().getProperties();
        CamelContextAwareTest.assertNotNull((String)"the properties should not been null", (Object)properties);
        CamelContextAwareTest.assertEquals((String)"No properties injected", (int)properties.size(), (int)1);
        CamelContextAwareTest.assertEquals((String)"Should get the value of org.apache.camel.test", (String)((String)properties.get("org.apache.camel.test")), (String)"this is a test first");
    }

    public void testCamelTemplates() throws Exception {
        DefaultProducerTemplate producer1 = this.getMandatoryBean(DefaultProducerTemplate.class, "producer1");
        CamelContextAwareTest.assertEquals((String)"Inject a wrong camel context", (String)producer1.getContext().getName(), (String)"camel1");
        DefaultProducerTemplate producer2 = this.getMandatoryBean(DefaultProducerTemplate.class, "producer2");
        CamelContextAwareTest.assertEquals((String)"Inject a wrong camel context", (String)producer2.getContext().getName(), (String)"camel2");
        DefaultConsumerTemplate consumer = this.getMandatoryBean(DefaultConsumerTemplate.class, "consumer");
        CamelContextAwareTest.assertEquals((String)"Inject a wrong camel context", (String)consumer.getCamelContext().getName(), (String)"camel2");
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.bean1 = this.getMandatoryBean(CamelContextAwareBean.class, "bean1");
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/camelContextAwareBean.xml");
    }

    @Override
    protected int getExpectedRouteCount() {
        return 0;
    }
}

