/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import junit.framework.TestCase;
import org.apache.camel.impl.ActiveMQUuidGenerator;
import org.apache.camel.impl.SimpleUuidGenerator;
import org.apache.camel.spi.UuidGenerator;
import org.apache.camel.spring.CamelContextFactoryBean;
import org.apache.camel.spring.SpringCamelContext;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.StaticApplicationContext;

public class CamelContextFactoryBeanTest
extends TestCase {
    private CamelContextFactoryBean factory;

    protected void setUp() throws Exception {
        super.setUp();
        this.factory = new CamelContextFactoryBean();
        this.factory.setId("camelContext");
    }

    public void testGetDefaultUuidGenerator() throws Exception {
        this.factory.setApplicationContext((ApplicationContext)new StaticApplicationContext());
        this.factory.afterPropertiesSet();
        UuidGenerator uuidGenerator = ((SpringCamelContext)this.factory.getContext()).getUuidGenerator();
        CamelContextFactoryBeanTest.assertTrue((boolean)(uuidGenerator instanceof ActiveMQUuidGenerator));
    }

    public void testGetCustomUuidGenerator() throws Exception {
        StaticApplicationContext applicationContext = new StaticApplicationContext();
        applicationContext.registerSingleton("uuidGenerator", SimpleUuidGenerator.class);
        this.factory.setApplicationContext((ApplicationContext)applicationContext);
        this.factory.afterPropertiesSet();
        UuidGenerator uuidGenerator = ((SpringCamelContext)this.factory.getContext()).getUuidGenerator();
        CamelContextFactoryBeanTest.assertTrue((boolean)(uuidGenerator instanceof SimpleUuidGenerator));
    }
}

