/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.Route;
import org.apache.camel.TestSupport;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.example.MyProcessor;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class CustomProcessorWithNamespacesTest
extends TestSupport {
    protected String body = "<hello>world!</hello>";
    protected AbstractXmlApplicationContext applicationContext;

    public void testXMLRouteLoading() throws Exception {
        this.applicationContext = this.createApplicationContext();
        SpringCamelContext context = (SpringCamelContext)this.applicationContext.getBeansOfType(SpringCamelContext.class).values().iterator().next();
        this.assertValidContext(context);
        ProducerTemplate template = context.createProducerTemplate();
        template.start();
        template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                Message in = exchange.getIn();
                in.setHeader("name", (Object)"James");
                in.setBody((Object)CustomProcessorWithNamespacesTest.this.body);
            }
        });
        template.stop();
        MyProcessor myProcessor = (MyProcessor)this.applicationContext.getBean("myProcessor");
        List<Exchange> list = myProcessor.getExchanges();
        CustomProcessorWithNamespacesTest.assertEquals((String)("Should have received a single exchange: " + list), (int)1, (int)list.size());
    }

    protected void assertValidContext(SpringCamelContext context) {
        CustomProcessorWithNamespacesTest.assertNotNull((String)"No context found!", (Object)context);
        List routes = context.getRoutes();
        CustomProcessorWithNamespacesTest.assertNotNull((String)"Should have some routes defined", (Object)routes);
        CustomProcessorWithNamespacesTest.assertEquals((String)"Number of routes defined", (int)1, (int)routes.size());
        Route route = (Route)routes.get(0);
        this.log.debug("Found route: " + route);
    }

    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/routingUsingProcessor.xml");
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        if (this.applicationContext != null) {
            this.applicationContext.destroy();
        }
    }
}

