/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.apache.camel.spring.SpringTestSupport;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class DefaultJMXAgentTest
extends SpringTestSupport {
    protected MBeanServerConnection mbsc;
    protected long sleepForConnection = 2000L;

    @Override
    protected void setUp() throws Exception {
        this.releaseMBeanServers();
        super.setUp();
        Thread.sleep(this.sleepForConnection);
        this.mbsc = this.getMBeanConnection();
    }

    @Override
    protected void tearDown() throws Exception {
        this.releaseMBeanServers();
        this.mbsc = null;
        super.tearDown();
    }

    protected void releaseMBeanServers() {
        ArrayList<MBeanServer> servers = MBeanServerFactory.findMBeanServer(null);
        for (MBeanServer server : servers) {
            MBeanServerFactory.releaseMBeanServer(server);
        }
    }

    public void testQueryMbeans() throws Exception {
        int before = this.mbsc.queryNames(new ObjectName("org.apache.camel:type=consumers,*"), null).size();
        this.context.startRoute("foo");
        int after = this.mbsc.queryNames(new ObjectName("org.apache.camel:type=consumers,*"), null).size();
        DefaultJMXAgentTest.assertTrue((String)("Should have added consumer to JMX, before: " + before + ", after: " + after), (after > before ? 1 : 0) != 0);
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/defaultJmxConfig.xml");
    }

    protected MBeanServerConnection getMBeanConnection() throws Exception {
        if (this.mbsc == null) {
            this.mbsc = ManagementFactory.getPlatformMBeanServer();
        }
        return this.mbsc;
    }
}

