/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.NoSuchEndpointException;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultRouteContext;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.SpringTestSupport;
import org.apache.camel.spring.example.DummyBean;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class EndpointReferenceTest
extends SpringTestSupport {
    protected static Object body = "<hello>world!</hello>";

    public void testContextToString() throws Exception {
        EndpointReferenceTest.assertNotNull((Object)this.context.toString());
    }

    public void testEndpointConfiguration() throws Exception {
        Endpoint endpoint = this.getMandatoryBean(Endpoint.class, "endpoint1");
        EndpointReferenceTest.assertEquals((String)"endpoint URI", (String)"direct://start", (String)endpoint.getEndpointUri());
        DummyBean dummyBean = this.getMandatoryBean(DummyBean.class, "mybean");
        EndpointReferenceTest.assertNotNull((String)"The bean should have an endpoint injected", (Object)dummyBean.getEndpoint());
        EndpointReferenceTest.assertEquals((String)"endpoint URI", (String)"direct://start", (String)dummyBean.getEndpoint().getEndpointUri());
        this.log.debug("Found dummy bean: " + dummyBean);
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:end");
        resultEndpoint.expectedBodiesReceived(new Object[]{body});
        this.template.sendBody("direct:start", body);
        resultEndpoint.assertIsSatisfied();
    }

    protected SpringCamelContext createCamelContext() {
        return (SpringCamelContext)this.applicationContext.getBean("camel");
    }

    public void testEndpointConfigurationAfterEnsuringThatTheStatementRouteBuilderWasCreated() throws Exception {
        String[] names;
        for (String name : names = this.applicationContext.getBeanDefinitionNames()) {
            this.log.debug("Found bean name: " + name);
        }
        this.testEndpointConfiguration();
    }

    public void testReferenceEndpointFromOtherCamelContext() throws Exception {
        CamelContext context = (CamelContext)this.applicationContext.getBean("camel2");
        DefaultRouteContext routeContext = new DefaultRouteContext(context);
        try {
            routeContext.resolveEndpoint(null, "endpoint1");
        }
        catch (NoSuchEndpointException exception) {
            EndpointReferenceTest.assertTrue((String)"Get a wrong exception message", (boolean)exception.getMessage().contains("make sure the endpoint has the same camel context as the route does"));
        }
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/endpointReference.xml");
    }
}

