/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.camel.spring.DefaultJMXAgentTest;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class JMXAgentTest
extends DefaultJMXAgentTest {
    protected static final String JMXSERVICEURL = "service:jmx:rmi:///jndi/rmi://localhost:20008/jmxrmi/camel";
    protected JMXConnector clientConnector;

    @Override
    protected void setUp() throws Exception {
        this.sleepForConnection = 2000L;
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.clientConnector != null) {
            try {
                this.clientConnector.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.clientConnector = null;
        }
        super.tearDown();
    }

    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/jmxConfig.xml");
    }

    @Override
    protected MBeanServerConnection getMBeanConnection() throws Exception {
        if (this.mbsc == null) {
            if (this.clientConnector == null) {
                this.clientConnector = JMXConnectorFactory.connect(new JMXServiceURL(JMXSERVICEURL), null);
            }
            this.mbsc = this.clientConnector.getMBeanServerConnection();
        }
        return this.mbsc;
    }
}

