/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import java.util.List;
import junit.framework.TestCase;
import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spring.Main;
import org.apache.camel.spring.example.MyProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MainTest
extends TestCase {
    private static final transient Logger LOG = LoggerFactory.getLogger(MainTest.class);

    public void testMain() throws Exception {
        Main main = new Main();
        main.addRouteBuilder(new RouteBuilder(){

            public void configure() throws Exception {
                ((RouteDefinition)this.from("file://src/test/data?noop=true").process((Processor)new MyProcessor())).to("mock:results");
            }
        });
        main.start();
        List contextList = main.getCamelContexts();
        MainTest.assertNotNull((Object)contextList);
        MainTest.assertEquals((String)"size", (int)1, (int)contextList.size());
        CamelContext camelContext = (CamelContext)contextList.get(0);
        MockEndpoint endpoint = (MockEndpoint)camelContext.getEndpoint("mock:results", MockEndpoint.class);
        endpoint.expectedMinimumMessageCount(2);
        endpoint.assertIsSatisfied();
        List list = endpoint.getReceivedExchanges();
        LOG.debug("Received: " + list);
        main.stop();
    }
}

