/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring;

import junit.framework.Assert;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spring.SpringTestSupport;
import org.slf4j.MDC;
import org.springframework.context.support.AbstractXmlApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class SpringMDCTest
extends SpringTestSupport {
    @Override
    protected AbstractXmlApplicationContext createApplicationContext() {
        return new ClassPathXmlApplicationContext("org/apache/camel/spring/SpringMDCTest.xml");
    }

    public void testMDC() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    public void testMDCTwoMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:a", (Object)"Hello World");
        this.template.sendBody("direct:a", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    public static class ProcessorB
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Assert.assertEquals((String)"route-b", (String)MDC.get((String)"routeId"));
            Assert.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"exchangeId"));
        }
    }

    public static class ProcessorA
    implements Processor {
        public void process(Exchange exchange) throws Exception {
            Assert.assertEquals((String)"route-a", (String)MDC.get((String)"routeId"));
            Assert.assertEquals((String)exchange.getExchangeId(), (String)MDC.get((String)"exchangeId"));
        }
    }
}

